/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.util.Properties;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.C3p0ConnectionFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class C3p0ConnectionFactoryTest {
    private C3p0ConnectionFactory cf;
    private AdjListJDBCCacheLoaderConfig config;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        Properties prop = this.load("cache-jdbc.properties");
        this.config = new AdjListJDBCCacheLoaderConfig();
        this.config.setProperties(prop);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cf.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetConfig() throws Exception {
        this.config.getProperties().setProperty("c3p0.checkoutTimeout", "10000");
        System.setProperty("c3p0.maxPoolSize", "5");
        this.config.getProperties().setProperty("c3p0.maxPoolSize", "3");
        this.cf = new C3p0ConnectionFactory();
        this.cf.setConfig(this.config);
        this.cf.start();
        Connection c1 = this.cf.getConnection();
        Connection c2 = this.cf.getConnection();
        Connection c3 = this.cf.getConnection();
        Connection c4 = this.cf.getConnection();
        Connection c5 = this.cf.getConnection();
        Connection c6 = null;
        try {
            c6 = this.cf.getConnection();
            AssertJUnit.fail((String)"Should have produced an SQLException indicating that it timed out checking out a Connection");
        }
        catch (Exception good) {
        }
        finally {
            this.cf.close(c1);
            this.cf.close(c2);
            this.cf.close(c3);
            this.cf.close(c4);
            this.cf.close(c5);
            this.cf.close(c6);
        }
    }

    public void testGetConnection() throws Exception {
        this.cf = new C3p0ConnectionFactory();
        this.cf.setConfig(this.config);
        this.cf.start();
        PooledDataSource internalDs = (PooledDataSource)this.cf.getDataSource();
        Connection c1 = this.cf.getConnection();
        Connection c2 = this.cf.getConnection();
        AssertJUnit.assertEquals((String)"There should be two connections checked out", (int)2, (int)internalDs.getNumBusyConnectionsDefaultUser());
        this.cf.close(c1);
        Thread.sleep(100L);
        AssertJUnit.assertEquals((String)"There should be one connection checked out", (int)1, (int)internalDs.getNumBusyConnectionsDefaultUser());
        this.cf.close(c2);
        Thread.sleep(100L);
        AssertJUnit.assertEquals((String)"There should be no connections checked out", (int)0, (int)internalDs.getNumBusyConnectionsDefaultUser());
    }

    private Properties load(String resource) throws Exception {
        Properties prop = new Properties();
        try {
            prop.load(this.getClass().getClassLoader().getResourceAsStream(resource));
            return prop;
        }
        catch (Exception e) {
            this.log("Error loading jdbc properties ");
            throw e;
        }
    }

    private void log(Object o) {
        System.out.println(o);
    }
}

