/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.ChainingCacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class CacheLoaderPurgingTest
extends AbstractCacheLoaderTestBase {
    private CacheSPI<Object, Object> cache;
    private String key = "key";
    private String value = "value";
    private Fqn fqn = Fqn.fromString((String)"/a/b/c");

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws CacheException {
        if (this.cache != null) {
            this.cache.removeNode(Fqn.ROOT);
            this.cache.stop();
            this.cache = null;
        }
    }

    public void testSingleLoaderNoPurge() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = this.cache.getConfiguration();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummySharedInMemoryCacheLoader.class.getName(), "", false, false, false));
        this.cache.start();
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        this.cache.evict(this.fqn);
        this.cache.stop();
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        this.cache.start();
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
    }

    public void testSingleLoaderPurge() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        Configuration c = this.cache.getConfiguration();
        c.setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", DummySharedInMemoryCacheLoader.class.getName(), "", false, false, false, true));
        this.cache.start();
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        CacheLoader loader = this.cache.getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        this.cache.evict(this.fqn);
        this.cache.stop();
        AssertJUnit.assertEquals((Object)this.value, loader.get(this.fqn).get(this.key));
        this.cache.start();
        AssertJUnit.assertTrue((boolean)this.cache.getCacheLoaderManager().getCacheLoaderConfig().getFirstCacheLoaderConfig().isPurgeOnStartup());
        AssertJUnit.assertNull((Object)this.cache.getNode(this.fqn));
        AssertJUnit.assertNull((Object)loader.get(this.fqn));
    }

    public void testTwoLoadersPurge() throws Exception {
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(false);
        String xml = "<config>\n<passivation>false</passivation>\n<preload></preload>\n<cacheloader>\n<class>" + DummySharedInMemoryCacheLoader.class.getName() + "</class>\n" + "<properties>" + " bin=bin1\n" + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>true</fetchPersistentState>\n" + "<purgeOnStartup>" + true + "</purgeOnStartup>\n" + "</cacheloader>\n" + "<cacheloader>\n" + "<class>" + DummySharedInMemoryCacheLoader.class.getName() + "</class>\n" + "<properties>" + " bin=bin2\n" + "</properties>\n" + "<async>false</async>\n" + "<fetchPersistentState>false</fetchPersistentState>\n" + "<purgeOnStartup>" + false + "</purgeOnStartup>\n" + "</cacheloader>\n" + "</config>";
        Configuration c = this.cache.getConfiguration();
        Element element = XmlHelper.stringToElement((String)xml);
        c.setCacheLoaderConfig(XmlConfigurationParser.parseCacheLoaderConfig((Element)element));
        this.cache.start();
        this.cache.put(this.fqn, (Object)this.key, (Object)this.value);
        CacheLoader[] loader = ((ChainingCacheLoader)this.cache.getCacheLoaderManager().getCacheLoader()).getCacheLoaders().toArray(new CacheLoader[0]);
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)this.value, loader[0].get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, loader[1].get(this.fqn).get(this.key));
        this.cache.evict(this.fqn);
        this.cache.stop();
        AssertJUnit.assertEquals((Object)this.value, loader[0].get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)this.value, loader[1].get(this.fqn).get(this.key));
        this.cache.start();
        AssertJUnit.assertTrue((!this.cache.exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertNull((Object)loader[0].get(this.fqn));
        AssertJUnit.assertNotNull((Object)loader[1].get(this.fqn));
        AssertJUnit.assertEquals((Object)this.value, (Object)this.cache.get(this.fqn, (Object)this.key));
    }
}

