/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false)
public class ConcurrentPutRemoveEvictTest
extends AbstractCacheLoaderTestBase {
    Cache<String, String> cache;
    Fqn fqn = Fqn.fromString((String)"/a");
    String key = "key";
    boolean run = true;
    Set<Exception> exceptions = new HashSet<Exception>();

    @BeforeTest
    public void setUp() throws Exception {
        CacheLoaderConfig cacheLoaderConfig = this.getSingleCacheLoaderConfig("", DummyInMemoryCacheLoader.class.getName(), "", false, false, false);
        Configuration cfg = new Configuration();
        cfg.setCacheLoaderConfig(cacheLoaderConfig);
        this.cache = new DefaultCacheFactory().createCache(cfg);
        this.cache.put(this.fqn, (Object)this.key, (Object)"value");
    }

    @AfterTest
    public void tearDown() {
        TestingUtil.killCaches(this.cache);
    }

    public void doTest() throws Exception {
        ArrayList<Thread> threads = new ArrayList<Thread>();
        threads.add(new Getter());
        threads.add(new RandomAdder());
        threads.add(new Evicter());
        for (Thread t : threads) {
            t.start();
        }
        TestingUtil.sleepThread(10000L);
        this.run = false;
        Iterator<Object> i$ = threads.iterator();
        while (i$.hasNext()) {
            Thread t;
            t = (Thread)i$.next();
            t.join();
        }
        if (!this.exceptions.isEmpty() && (i$ = this.exceptions.iterator()).hasNext()) {
            Exception e = (Exception)i$.next();
            throw e;
        }
    }

    private class Evicter
    extends Thread {
        private Evicter() {
        }

        public void run() {
            while (ConcurrentPutRemoveEvictTest.this.run) {
                try {
                    ConcurrentPutRemoveEvictTest.this.cache.evict(ConcurrentPutRemoveEvictTest.this.fqn);
                }
                catch (Exception exception) {}
            }
        }
    }

    private class Getter
    extends Thread {
        private Getter() {
        }

        public void run() {
            while (ConcurrentPutRemoveEvictTest.this.run) {
                try {
                    String value = (String)ConcurrentPutRemoveEvictTest.this.cache.get(ConcurrentPutRemoveEvictTest.this.fqn, (Object)ConcurrentPutRemoveEvictTest.this.key);
                    System.out.println("Thread " + this.getName() + " got value " + value);
                }
                catch (Exception e) {
                    ConcurrentPutRemoveEvictTest.this.exceptions.add(e);
                }
            }
        }
    }

    private class RandomAdder
    extends Thread {
        private RandomAdder() {
        }

        public void run() {
            int i = 0;
            while (ConcurrentPutRemoveEvictTest.this.run) {
                try {
                    ConcurrentPutRemoveEvictTest.this.cache.put(ConcurrentPutRemoveEvictTest.this.fqn, (Object)(ConcurrentPutRemoveEvictTest.this.key + i++), (Object)"");
                }
                catch (Exception exception) {}
            }
        }
    }
}

