/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import org.jboss.cache.Fqn;
import org.jboss.cache.loader.CacheLoaderTestsBase;
import org.jboss.cache.loader.FileCacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class FileCacheLoaderTest
extends CacheLoaderTestsBase {
    protected void configureCache() throws Exception {
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        String tmpCLLoc = tmpDir + "/JBossCache-FileCacheLoaderTest";
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.FileCacheLoader", "location=" + tmpCLLoc, false, true, false));
        TestingUtil.recursiveFileRemove(tmpCLLoc);
    }

    public void testIsCharacterPortableLocation() {
        Object[][] data;
        FileCacheLoader fcl = new FileCacheLoader();
        for (Object[] aData : data = new Object[][]{{"C:\\here\\there.txt", true}, {"/home/here/there", true}, {"/home/*/jboss", false}, {"C:\\>/jgroups/jboss", false}, {"/cache/jboss<", false}, {"/pojocache|/galder", false}, {"/pojocache/gal\"der", false}}) {
            String path = (String)aData[0];
            boolean expected = (Boolean)aData[1];
            AssertJUnit.assertEquals((String)path, (boolean)expected, (boolean)fcl.isCharacterPortableLocation(path));
        }
    }

    public void testIsCharacterPortableTree() {
        Object[][] data;
        FileCacheLoader fcl = new FileCacheLoader();
        for (Object[] aData : data = new Object[][]{{Fqn.fromString((String)"/a/b/c/d/e"), true}, {Fqn.fromString((String)"/a/*/c/d/e"), false}, {Fqn.fromString((String)"/a/b/>/d/e"), false}, {Fqn.fromString((String)"/a/</c/d/e"), false}, {Fqn.fromString((String)"/|/b/c/d/e"), false}, {Fqn.fromString((String)"/|/b/c/d/e"), false}, {Fqn.fromString((String)"/a/b/c/d/\""), false}, {Fqn.fromString((String)"/a/b/c/d/\\"), false}, {Fqn.fromString((String)"/a/b/c/d///"), true}, {Fqn.fromString((String)"/a/b/c/:/e"), false}}) {
            Fqn fqn = (Fqn)aData[0];
            boolean expected = (Boolean)aData[1];
            AssertJUnit.assertEquals((String)fqn.toString(), (boolean)expected, (boolean)fcl.isCharacterPortableTree(fqn));
        }
    }

    public void testIsLengthPortablePath() {
        Object[][] data;
        FileCacheLoader fcl = new FileCacheLoader();
        for (Object[] aData : data = new Object[][]{{"C:\\here\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\web_services\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\webservices\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\data.dat", true}, {"C:\\there\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\web_services\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\webservices\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\data.dat", true}, {"C:\\deerme\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\web_services\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\webservices\\org\\jboss\\cache\\jgroups\\pojocache\\application\\server\\clustering\\portal\\data.dat", true}}) {
            String path = (String)aData[0];
            boolean expected = (Boolean)aData[1];
            AssertJUnit.assertEquals((String)path, (boolean)expected, (boolean)fcl.isLengthPortablePath(path));
        }
    }
}

