/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.sql.Connection;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.JDBCCacheLoader;
import org.jboss.cache.loader.NonManagedConnectionFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class JDBCCacheLoaderConnectionTest
extends AbstractCacheLoaderTestBase {
    private Cache cache;

    @BeforeMethod
    public void setUp() throws Exception {
        String props = "               cache.jdbc.table.name=jbosscache_engine_cache\n                        cache.jdbc.table.create=true\n                        cache.jdbc.table.drop=true\n                        cache.jdbc.table.primarykey=jbosscache_engine_cache_pk\n                        cache.jdbc.fqn.column=fqn\n                        cache.jdbc.fqn.type=varchar(255)\n                        cache.jdbc.node.column=node\n                        cache.jdbc.node.type=blob\n                        cache.jdbc.parent.column=parent\n                        cache.jdbc.sql-concat=1 || 2\n                        cache.jdbc.driver=org.apache.derby.jdbc.EmbeddedDriver\n                        cache.jdbc.url=jdbc:derby:jbossdb;create=true\n                        cache.jdbc.user=user1\n                        cache.jdbc.password=user1";
        this.cache = new DefaultCacheFactory().createCache(false);
        this.cache.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", JDBCCacheLoader.class.getName(), props, false, false, true, false));
        this.cache.start();
    }

    @AfterMethod
    public void tearDown() {
        this.cache.stop();
    }

    public void testConnectionRelease() throws Exception {
        this.cache.removeNode(Fqn.fromString((String)"C"));
        for (int i = 0; i < 100; ++i) {
            this.cache.put(Fqn.fromElements((Object[])new String[]{"C", Integer.toString(i)}), (Object)"Blah", (Object)Integer.toString(i));
            System.out.println("added " + i + " dummy node to Jboss cache.");
        }
        this.assertConnectionsClosed();
    }

    private void assertConnectionsClosed() throws Exception {
        JDBCCacheLoader loader = (JDBCCacheLoader)((CacheSPI)this.cache).getCacheLoaderManager().getCacheLoader();
        NonManagedConnectionFactory cf = (NonManagedConnectionFactory)loader.cf;
        Connection conn = (Connection)NonManagedConnectionFactory.connection.get();
        if (conn != null) assert (conn.isClosed());
    }
}

