/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.HashMap;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class BreakDeadMemberLocksTest {
    private Map<String, CacheSPI<Object, Object>> caches;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.caches = new HashMap<String, CacheSPI<Object, Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBreakDeadMemberLocks() throws Exception {
        CacheSPI<Object, Object> cacheA = this.createCache("A");
        cacheA.put("/1/A", (Object)"1", (Object)"A");
        cacheA.put("/1/A", (Object)"2", (Object)"A");
        cacheA.put("/2/A", (Object)"1", (Object)"A");
        cacheA.put("/2/A", (Object)"2", (Object)"A");
        cacheA.put("/1/A/I", (Object)"1", (Object)"A");
        cacheA.put("/1/A/I", (Object)"2", (Object)"A");
        CacheSPI<Object, Object> cacheB = this.createCache("B");
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{cacheA, cacheB}, 60000L);
        final TransactionManager tm = cacheB.getTransactionManager();
        tm.begin();
        final Transaction tx = tm.getTransaction();
        cacheB.put("/1/A", (Object)"1", (Object)"B");
        cacheB.put("/1/A", (Object)"2", (Object)"B");
        cacheB.put("/2/A", (Object)"1", (Object)"B");
        cacheB.put("/2/A", (Object)"2", (Object)"B");
        cacheB.put("/1/A/I", (Object)"1", (Object)"B");
        cacheB.put("/1/A/I", (Object)"2", (Object)"B");
        cacheB.put("/EXISTS", (Object)"KEY", (Object)"B");
        Object monitor = new Object();
        HangSync sync = new HangSync(monitor);
        tx.registerSynchronization((Synchronization)sync);
        Thread t = new Thread(){

            public void run() {
                try {
                    tm.resume(tx);
                    tm.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Object object = monitor;
        synchronized (object) {
            t.start();
            while (!sync.hung) {
                monitor.wait(500L);
            }
        }
        tm.suspend();
        AssertJUnit.assertTrue((cacheA.peek(Fqn.fromString((String)"/EXISTS"), false, false) != null ? 1 : 0) != 0);
        cacheB.stop();
        cacheB.destroy();
        while (cacheA.getMembers().size() > 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        AssertJUnit.assertEquals((Object)"A", (Object)cacheA.get("/1/A", (Object)"1"));
        AssertJUnit.assertEquals((Object)"A", (Object)cacheA.get("/1/A", (Object)"2"));
        AssertJUnit.assertEquals((Object)"A", (Object)cacheA.get("/2/A", (Object)"1"));
        AssertJUnit.assertEquals((Object)"A", (Object)cacheA.get("/2/A", (Object)"2"));
        AssertJUnit.assertEquals((Object)"A", (Object)cacheA.get("/1/A/I", (Object)"1"));
        AssertJUnit.assertEquals((Object)"A", (Object)cacheA.get("/1/A/I", (Object)"2"));
        if (t.isAlive()) {
            t.interrupt();
        }
    }

    protected CacheSPI<Object, Object> createCache(String cacheID) throws Exception {
        if (this.caches.get(cacheID) != null) {
            throw new IllegalStateException(cacheID + " already created");
        }
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC), false);
        cache.create();
        cache.start();
        this.caches.put(cacheID, (CacheSPI<Object, Object>)cache);
        return cache;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (String cacheID : this.caches.keySet()) {
            this.stopCache(cacheID);
        }
        this.caches.clear();
    }

    protected void stopCache(String id) {
        TestingUtil.killCaches((Cache)this.caches.get(id));
    }

    class HangSync
    implements Synchronization {
        private boolean hung = false;
        private Object monitor;

        HangSync(Object monitor) {
            this.monitor = monitor;
        }

        public void afterCompletion(int arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeCompletion() {
            this.hung = true;
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

