/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class InvalidRegionForStateTransferTest {
    Cache<Object, Object> c1;
    Cache<Object, Object> c2;
    ReplicationListener replListener2;

    @BeforeMethod
    public void setUp() throws CloneNotSupportedException {
        this.c1 = new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC), false);
        String jgroupsCfg = this.c1.getConfiguration().getClusterConfig();
        jgroupsCfg = jgroupsCfg.replace("STREAMING_STATE_TRANSFER", "STATE_TRANSFER");
        jgroupsCfg = jgroupsCfg.replaceFirst("thread_pool.max_threads=[0-9]*;", "thread_pool.max_threads=1;");
        System.out.println(">>>> " + jgroupsCfg);
        this.c1.getConfiguration().setClusterConfig(jgroupsCfg);
        this.c1.getConfiguration().setUseRegionBasedMarshalling(true);
        this.c1.start();
        this.c2 = new DefaultCacheFactory().createCache(this.c1.getConfiguration().clone());
        this.replListener2 = new ReplicationListener(this.c2);
        TestingUtil.blockUntilViewsReceived(60000L, this.c1, this.c2);
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(this.c1, this.c2);
    }

    public void testUseOfInvalidRegion() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c/d");
        this.c1.getRegion(fqn.getParent(), true).registerContextClassLoader(this.getClass().getClassLoader());
        this.c2.getRegion(fqn.getParent(), true).registerContextClassLoader(this.getClass().getClassLoader());
        this.replListener2.expectAny();
        this.c1.put(fqn, (Object)"k", (Object)"v");
        assert (this.c1.get(fqn, (Object)"k").equals("v"));
        this.replListener2.waitForReplicationToOccur(250L);
        assert (this.c2.get(fqn, (Object)"k").equals("v"));
        this.c1.destroy();
        this.c1.create();
        Region r = this.c1.getRegion(fqn.getParent(), true);
        r.registerContextClassLoader(this.getClass().getClassLoader());
        r.deactivate();
        this.c1.start();
        TestingUtil.blockUntilViewsReceived(60000L, this.c1, this.c2);
        assert (this.c1.get(fqn, (Object)"k").equals("v"));
    }
}

