/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.mgmt;

import java.util.HashMap;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.mgmt.MgmtTestBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class PassivationTest
extends MgmtTestBase {
    public PassivationTest() {
        this.passivation = true;
    }

    public void testPassivationMgmt() throws Exception {
        AssertJUnit.assertNotNull((String)"Cache is null.", (Object)this.cache);
        ActivationInterceptor act = TestingUtil.findInterceptor(this.cache, ActivationInterceptor.class);
        AssertJUnit.assertNotNull((String)"ActivationInterceptor not found.", (Object)act);
        PassivationInterceptor pass = TestingUtil.findInterceptor(this.cache, PassivationInterceptor.class);
        AssertJUnit.assertNotNull((String)"PassivationInterceptor not found.", (Object)pass);
        System.out.println("count of misses " + act.getCacheLoaderMisses());
        int miss = 5;
        int activations = 0;
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)0L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)0L, (long)pass.getPassivations());
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"capital"));
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"area"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)0L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)0L, (long)pass.getPassivations());
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve capital for " + POLAND), (Object)this.cache.get(POLAND, (Object)"capital"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)0L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)(++miss), (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)0L, (long)pass.getPassivations());
        this.cache.evict(AUSTRIA, false);
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to find node " + AUSTRIA + " in cache"), (Object)this.cache.peek(AUSTRIA, false));
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)1L, (long)pass.getPassivations());
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve capital for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"capital"));
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"currency"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)1L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)(++activations), (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)1L, (long)pass.getPassivations());
        this.cache.removeNode(AUSTRIA);
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to find node " + AUSTRIA + " in cache"), (Object)this.cache.peek(AUSTRIA, false));
        AssertJUnit.assertFalse((String)("Retrieval error: did not expect to find node " + AUSTRIA + " in loader"), (boolean)this.cl.exists(AUSTRIA));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)1L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)1L, (long)pass.getPassivations());
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve capital for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"capital"));
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve currency for " + AUSTRIA), (Object)this.cache.get(AUSTRIA, (Object)"currency"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)1L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)(miss += 2), (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)1L, (long)pass.getPassivations());
        ++miss;
        this.cache.put(POLAND, new HashMap());
        this.cache.put(POLAND, (Object)"capital", (Object)"Warsaw");
        this.cache.put(POLAND, (Object)"currency", (Object)"Zloty");
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)1L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)1L, (long)pass.getPassivations());
        this.cache.evict(POLAND, false);
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)1L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)2L, (long)pass.getPassivations());
        AssertJUnit.assertNotNull((String)("Retrieval error: expected to retrieve currency for " + POLAND), (Object)this.cache.get(POLAND, (Object)"currency"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)2L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)(++activations), (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)2L, (long)pass.getPassivations());
        this.cache.evict(POLAND, false);
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)2L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)activations, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)3L, (long)pass.getPassivations());
        AssertJUnit.assertNull((String)("Retrieval error: did not expect to retrieve area for " + POLAND), (Object)this.cache.get(POLAND, (Object)"area"));
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error: ", (long)3L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error: ", (long)miss, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)(++activations), (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)3L, (long)pass.getPassivations());
        act.resetStatistics();
        pass.resetStatistics();
        AssertJUnit.assertEquals((String)"CacheLoaderLoads count error after reset: ", (long)0L, (long)act.getCacheLoaderLoads());
        AssertJUnit.assertEquals((String)"CacheLoaderMisses count error after reset: ", (long)0L, (long)act.getCacheLoaderMisses());
        AssertJUnit.assertEquals((String)"Activations count error: ", (long)0L, (long)act.getActivations());
        AssertJUnit.assertEquals((String)"Passivations count error: ", (long)0L, (long)pass.getPassivations());
    }
}

