/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.optimistic.AbstractOptimisticTestCase;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class HasChildTest
extends AbstractOptimisticTestCase {
    private CacheSPI<Object, Object> cache;
    private TransactionManager txMgr;
    private Fqn f = Fqn.fromString((String)"/a");

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache = this.createCache();
        this.txMgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        super.tearDown();
        this.destroyCache((Cache<Object, Object>)this.cache);
    }

    public void testExists() throws Exception {
        this.cache.put(this.f, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.f));
        this.cache.removeNode(this.f);
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.f));
        this.txMgr.begin();
        this.cache.put(this.f, (Object)"k", (Object)"v");
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.f));
        Transaction t = this.txMgr.suspend();
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.f));
        this.txMgr.resume(t);
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.f));
        this.txMgr.commit();
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.f));
        this.txMgr.begin();
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.f));
        this.cache.removeNode(this.f);
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.f));
        t = this.txMgr.suspend();
        AssertJUnit.assertTrue((boolean)this.cache.getRoot().hasChild(this.f));
        this.txMgr.resume(t);
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.f));
        this.txMgr.commit();
        AssertJUnit.assertFalse((boolean)this.cache.getRoot().hasChild(this.f));
    }
}

