/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.options;

import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.options.TestVersion;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ExplicitVersionsReplTest {
    private CacheSPI[] cache;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private String key = "key";

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        if (this.cache != null) {
            this.tearDown();
        }
        this.cache = new CacheSPI[2];
        this.cache[0] = this.createCache();
        this.cache[1] = this.createCache();
        TestingUtil.blockUntilViewsReceived(this.cache, 20000L);
    }

    private CacheSPI createCache() {
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setNodeLockingScheme("OPTIMISTIC");
        c.setSyncCommitPhase(true);
        c.setSyncRollbackPhase(true);
        c.setSyncReplTimeout(1000L);
        c.setLockAcquisitionTimeout(1000L);
        c.setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        return (CacheSPI)new DefaultCacheFactory().createCache(c);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.cache != null) {
            for (CacheSPI aCache : this.cache) {
                this.destroyCache(aCache);
            }
            this.cache = null;
        }
    }

    private void destroyCache(CacheSPI c) {
        TransactionManager tm = c.getTransactionManager();
        try {
            if (tm != null && tm.getTransaction() != null) {
                tm.rollback();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        c.stop();
    }

    public void testIncompatibleVersionTypes1() throws Exception {
        TestVersion version = new TestVersion("99");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache[0].getTransactionManager();
        mgr.begin();
        System.out.println("************ stage 2");
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        try {
            mgr.commit();
            AssertJUnit.assertTrue((String)"expected to fail", (boolean)false);
        }
        catch (RollbackException e) {
            AssertJUnit.assertTrue((String)"expected to fail with a nested ClassCastException", (boolean)true);
        }
    }

    public void testCompatibleVersionTypes1() throws Exception {
        TestVersion version = new TestVersion("99");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache[0].getTransactionManager();
        mgr.begin();
        version = new TestVersion("999");
        this.cache[1].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        mgr.commit();
    }

    public void testCompatibleVersionTypesOutDatedVersion1() throws Exception {
        TestVersion version = new TestVersion("99");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache[0].getTransactionManager();
        mgr.begin();
        version = new TestVersion("29");
        this.cache[1].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        try {
            mgr.commit();
            AssertJUnit.assertTrue((String)"expected to fail", (boolean)false);
        }
        catch (RollbackException e) {
            AssertJUnit.assertTrue((String)"expected to fail with a CacheException to do with a versioning mismatch", (boolean)true);
        }
    }

    public void testIncompatibleVersionTypes2() throws Exception {
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache[0].getTransactionManager();
        mgr.begin();
        TestVersion version = new TestVersion("99");
        this.cache[1].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        try {
            this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
            mgr.commit();
            AssertJUnit.assertTrue((String)"expected to fail", (boolean)false);
        }
        catch (Exception e) {
            AssertJUnit.assertTrue((String)"expected to fail", (boolean)true);
        }
    }

    public void testCompatibleVersionTypes2() throws Exception {
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache[0].getTransactionManager();
        mgr.begin();
        DefaultDataVersion version = new DefaultDataVersion(300L);
        this.cache[1].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        mgr.commit();
    }

    public void testCompatibleVersionTypesOutDatedVersion2() throws Exception {
        DefaultDataVersion version = new DefaultDataVersion(200L);
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        TransactionManager mgr = this.cache[0].getTransactionManager();
        mgr.begin();
        version = new DefaultDataVersion(100L);
        this.cache[1].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)version);
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        try {
            mgr.commit();
            AssertJUnit.assertTrue((String)"expected to fail", (boolean)false);
        }
        catch (Exception e) {
            AssertJUnit.assertTrue((String)"expected to fail with a CacheException to do with a versioning mismatch", (boolean)true);
        }
    }

    public void testPropagationOfDefaultVersions() throws Exception {
        DefaultDataVersion expected = new DefaultDataVersion();
        expected = (DefaultDataVersion)expected.increment();
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache[0].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache[1].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[0].getNode(this.fqn).getVersion());
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[1].getNode(this.fqn).getVersion());
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        expected = (DefaultDataVersion)expected.increment();
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache[0].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache[1].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[0].getNode(this.fqn).getVersion());
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[1].getNode(this.fqn).getVersion());
    }

    public void testPropagationOfCustomVersions() throws Exception {
        TestVersion expected = new TestVersion("100");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)expected);
        this.cache[0].put(this.fqn, (Object)this.key, (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache[0].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache[1].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[0].getNode(this.fqn).getVersion());
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[1].getNode(this.fqn).getVersion());
        expected = new TestVersion("200");
        this.cache[1].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)expected);
        this.cache[1].put(this.fqn, (Object)this.key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache[0].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache[1].get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[0].getNode(this.fqn).getVersion());
        AssertJUnit.assertEquals((Object)expected, (Object)this.cache[1].getNode(this.fqn).getVersion());
    }

    public void testExplicitVersionOnRoot() throws Exception {
        TestVersion newVersion = new TestVersion("100");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)newVersion);
        this.cache[0].getTransactionManager().begin();
        this.cache[0].put(Fqn.ROOT, (Object)"k", (Object)"v");
        try {
            this.cache[0].getTransactionManager().commit();
            AssertJUnit.fail((String)"Should have barfed");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
    }

    public void testExplicitVersionOnLeaf() throws Exception {
        this.cache[0].put("/org/domain/Entity", null);
        AssertJUnit.assertEquals((long)1L, (long)((DefaultDataVersion)this.cache[0].getNode("/org/domain/Entity").getVersion()).getRawVersion());
        AssertJUnit.assertEquals((long)1L, (long)((DefaultDataVersion)this.cache[1].getNode("/org/domain/Entity").getVersion()).getRawVersion());
        TestVersion v = new TestVersion("Arse");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)v);
        this.cache[0].put(Fqn.fromString((String)"/org/domain/Entity/EntityInstance#1"), (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((long)1L, (long)((DefaultDataVersion)this.cache[0].getNode("/org/domain/Entity").getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)v, (Object)this.cache[0].getNode("/org/domain/Entity/EntityInstance#1").getVersion());
        AssertJUnit.assertEquals((long)1L, (long)((DefaultDataVersion)this.cache[1].getNode("/org/domain/Entity").getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)v, (Object)this.cache[1].getNode("/org/domain/Entity/EntityInstance#1").getVersion());
    }

    public void testExplicitVersionOnLeafImplicitParentCreation() throws Exception {
        TestVersion v = new TestVersion("Arse");
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)v);
        this.cache[0].put(Fqn.fromString((String)"/org/domain/Entity/EntityInstance#1"), (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)this.cache[0].getNode("/org/domain/Entity").getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)v, (Object)this.cache[0].getNode("/org/domain/Entity/EntityInstance#1").getVersion());
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)this.cache[1].getNode("/org/domain/Entity").getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)v, (Object)this.cache[1].getNode("/org/domain/Entity/EntityInstance#1").getVersion());
    }

    public void testExplicitVersionOnParentAndChild() throws Exception {
        TestVersion vParent = new TestVersion("Parent-Version");
        this.cache[0].getTransactionManager().begin();
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)vParent);
        this.cache[0].put(Fqn.fromString((String)"/parent"), (Object)"k", (Object)"v");
        this.cache[0].getTransactionManager().commit();
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)this.cache[0].getRoot().getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)vParent, (Object)this.cache[0].getNode("/parent").getVersion());
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)this.cache[1].getRoot().getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)vParent, (Object)this.cache[1].getNode("/parent").getVersion());
        TestVersion vChild = new TestVersion("Child-Version");
        this.cache[0].getTransactionManager().begin();
        this.cache[0].getInvocationContext().getOptionOverrides().setDataVersion((DataVersion)vChild);
        this.cache[0].put(Fqn.fromString((String)"/parent/child"), (Object)"k", (Object)"v");
        this.cache[0].getTransactionManager().commit();
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)this.cache[0].getRoot().getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)vParent, (Object)this.cache[0].getNode("/parent").getVersion());
        AssertJUnit.assertEquals((Object)vChild, (Object)this.cache[0].getNode("/parent/child").getVersion());
        AssertJUnit.assertEquals((long)0L, (long)((DefaultDataVersion)this.cache[1].getRoot().getVersion()).getRawVersion());
        AssertJUnit.assertEquals((Object)vParent, (Object)this.cache[1].getNode("/parent").getVersion());
        AssertJUnit.assertEquals((Object)vChild, (Object)this.cache[1].getNode("/parent/child").getVersion());
    }
}

