/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.profiling.AbstractProfileTest;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"profiling"})
public class ProfileSlaveTest
extends AbstractProfileTest {
    private void waitForTest() throws Exception {
        System.out.println("Slave listening for remote connections.  Hit Enter when done.");
        System.in.read();
    }

    @Test(enabled=false)
    public void testReplSync() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setExposeManagementStatistics(true);
        this.cache.start();
        this.waitForTest();
    }

    @Test(enabled=true)
    public void testReplAsync() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setClusterConfig(this.getJGroupsConfig());
        this.cache.start();
        this.waitForTest();
    }

    @Test(enabled=false)
    public void testReplSyncOptimistic() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.waitForTest();
    }

    @Test(enabled=false)
    public void testReplAsyncOptimistic() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.cache.start();
        this.waitForTest();
    }

    @Test(enabled=false)
    public void testReplSyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSync();
    }

    @Test(enabled=false)
    public void testReplAsyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        this.testReplAsync();
    }

    @Test(enabled=false)
    public void testReplSyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSyncOptimistic();
    }

    @Test(enabled=false)
    public void testReplAsyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsyncOptimistic();
    }

    @Test(enabled=false)
    public void testStateTransfer() throws Exception {
        throw new Exception("Implement me");
    }

    @Test(enabled=false)
    public void testStartup() throws Exception {
        throw new Exception("Implement me");
    }

    @Test(enabled=false)
    public void testCacheLoading() throws Exception {
        throw new Exception("Implement me");
    }

    @Test(enabled=false)
    public void testPassivation() throws Exception {
        throw new Exception("Implement me");
    }
}

