/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.profiling.AbstractProfileTest;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.testng.annotations.Test;

@Test(groups={"profiling"})
public class ProfileTest
extends AbstractProfileTest {
    protected static final long NUM_OPERATIONS = 1000000L;
    protected static final int NUM_THREADS = 25;
    protected static final int MAX_RANDOM_SLEEP_MILLIS = 1;
    protected static final int MAX_DEPTH = 3;
    protected static final int MAX_OVERALL_NODES = 50;
    protected static final int WARMUP_LOOPS = 20000;
    protected static final boolean USE_SLEEP = false;
    protected static final Fqn BELAS_FQN = Fqn.fromString((String)"/a/b/c");
    protected static final String BELAS_KEY = "bela";
    private List<Fqn> fqns = new ArrayList<Fqn>(50);
    private Random r = new Random();
    Log log = LogFactory.getLog(ProfileTest.class);

    @Test(enabled=true)
    public void testLocalModePess() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        this.runCompleteTest();
    }

    @Test(enabled=false)
    public void testLocalModeOpt() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.LOCAL);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.runCompleteTest();
    }

    @Test(enabled=false)
    public void testReplSync() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.runCompleteTest();
    }

    @Test(enabled=true)
    public void testReplAsync() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setClusterConfig(this.getJGroupsConfig());
        this.runCompleteTest();
    }

    @Test(enabled=false)
    public void testReplSyncOptimistic() throws Exception {
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.runCompleteTest();
    }

    @Test(enabled=false)
    public void testReplAsyncOptimistic() throws Exception {
        this.cache.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_ASYNC);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        this.cache.getConfiguration().setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        this.runCompleteTest();
    }

    @Test(enabled=false)
    public void testReplSyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSync();
    }

    @Test(enabled=false)
    public void testReplAsyncBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.cache.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.PESSIMISTIC);
        this.cache.getConfiguration().setIsolationLevel(IsolationLevel.READ_COMMITTED);
        this.testReplAsync();
    }

    @Test(enabled=false)
    public void testReplSyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplSyncOptimistic();
    }

    @Test(enabled=false)
    public void testReplAsyncOptBR() throws Exception {
        BuddyReplicationConfig brc = new BuddyReplicationConfig();
        brc.setEnabled(true);
        this.cache.getConfiguration().setBuddyReplicationConfig(brc);
        this.testReplAsyncOptimistic();
    }

    private void runCompleteTest() throws Exception {
        this.init();
        this.startup();
        this.warmup();
        this.doTest();
        System.in.read();
    }

    protected void init() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting init() phase");
        this.fqns.clear();
        for (int i = 0; i < 50; ++i) {
            Fqn fqn = this.createRandomFqn(this.r);
            while (this.fqns.contains(fqn)) {
                fqn = this.createRandomFqn(this.r);
            }
            if (i % 10 == 0) {
                this.log.warn((Object)("Generated " + i + " fqns"));
            }
            this.fqns.add(fqn);
        }
        System.gc();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished init() phase.  " + this.printDuration(duration)));
    }

    private Fqn createRandomFqn(Random r) {
        String s = "/";
        int depth = r.nextInt(3);
        for (int i = 0; i < depth; ++i) {
            s = s + r.nextInt(Integer.MAX_VALUE) + "/";
        }
        return Fqn.fromString((String)s);
    }

    protected void startup() {
        long startTime = System.currentTimeMillis();
        this.log.warn((Object)"Starting cache");
        this.cache.start();
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Started cache.  " + this.printDuration(duration)));
    }

    private void warmup() throws InterruptedException {
        long startTime = System.currentTimeMillis();
        ExecutorService exec = Executors.newFixedThreadPool(25);
        this.log.warn((Object)"Starting warmup");
        for (final Fqn f : this.fqns) {
            exec.execute(new Runnable(){

                public void run() {
                    ProfileTest.this.cache.put(f, Collections.emptyMap());
                }
            });
        }
        for (int i = 0; i < 20000; ++i) {
            exec.execute(new Runnable(){

                public void run() {
                    Fqn f = (Fqn)ProfileTest.this.fqns.get(ProfileTest.this.r.nextInt(50));
                    ProfileTest.this.cache.get(f, (Object)"");
                    ProfileTest.this.cache.put(f, (Object)"k", (Object)"v");
                    ProfileTest.this.cache.remove(f, (Object)"k");
                }
            });
        }
        exec.shutdown();
        exec.awaitTermination(360L, TimeUnit.SECONDS);
        long duration = System.currentTimeMillis() - startTime;
        this.log.warn((Object)("Finished warmup.  " + this.printDuration(duration)));
        this.cache.stop();
        this.startup();
    }

    private void doTest() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(25);
        this.log.warn((Object)"Starting test");
        long print = 100000L;
        AtomicLong durationPuts = new AtomicLong();
        AtomicLong durationGets = new AtomicLong();
        AtomicLong durationRemoves = new AtomicLong();
        long stElapsed = System.nanoTime();
        int i = 0;
        while ((long)i < 1000000L) {
            MyRunnable r = null;
            switch (i % 3) {
                case 0: {
                    r = new Putter(i, durationPuts);
                    break;
                }
                case 1: {
                    r = new Getter(i, durationGets);
                    break;
                }
                case 2: {
                    r = new Remover(i, durationRemoves);
                }
            }
            if ((long)i % print == 0L) {
                this.log.warn((Object)("processing iteration " + i));
            }
            exec.execute(r);
            ++i;
        }
        this.log.warn((Object)"Finished generating runnables; awaiting executor completion");
        exec.shutdown();
        while (!exec.awaitTermination(i, TimeUnit.SECONDS)) {
            Thread.sleep(1L);
        }
        long elapsedTimeNanos = System.nanoTime() - stElapsed;
        this.log.warn((Object)("Finished test.  " + this.printDuration((long)this.toMillis(elapsedTimeNanos))));
        this.log.warn((Object)("Throughput: " + 1.0E9 / this.toMillis(elapsedTimeNanos) + " operations per second (roughly equal numbers of PUT, GET and REMOVE)"));
        this.log.warn((Object)("Average GET time: " + this.printAvg(durationGets.get())));
        this.log.warn((Object)("Average PUT time: " + this.printAvg(durationPuts.get())));
        this.log.warn((Object)("Average REMOVE time: " + this.printAvg(durationRemoves.get())));
    }

    private String printAvg(long totalNanos) {
        double nOps = 333333.0;
        double avg = (double)totalNanos / nOps;
        double avgMicros = avg / 1000.0;
        return avgMicros + " \u00b5s";
    }

    private double toMillis(long nanos) {
        return (double)nanos / 1000000.0;
    }

    private String getRandomString() {
        StringBuilder sb = new StringBuilder();
        int len = this.r.nextInt(10);
        for (int i = 0; i < len; ++i) {
            sb.append((char)(63 + this.r.nextInt(26)));
        }
        return sb.toString();
    }

    String printDuration(long duration) {
        if (duration > 2000L) {
            double dSecs = (double)duration / 1000.0;
            return "Duration: " + dSecs + " seconds";
        }
        return "Duration: " + duration + " millis";
    }

    @Test(enabled=false)
    public void testStateTransfer() throws Exception {
        throw new Exception("Implement me");
    }

    @Test(enabled=false)
    public void testStartup() throws Exception {
        throw new Exception("Implement me");
    }

    @Test(enabled=false)
    public void testCacheLoading() throws Exception {
        throw new Exception("Implement me");
    }

    @Test(enabled=false)
    public void testPassivation() throws Exception {
        throw new Exception("Implement me");
    }

    private class Remover
    extends MyRunnable {
        private Remover(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.REMOVE;
        }
    }

    private class Getter
    extends MyRunnable {
        private Getter(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.GET;
        }
    }

    private class Putter
    extends MyRunnable {
        private Putter(int id, AtomicLong duration) {
            this.id = id;
            this.duration = duration;
            this.mode = Mode.PUT;
        }
    }

    private abstract class MyRunnable
    implements Runnable {
        int id;
        Mode mode;
        AtomicLong duration;

        private MyRunnable() {
        }

        public void run() {
            String k = ProfileTest.this.getRandomString();
            Fqn f = (Fqn)ProfileTest.this.fqns.get(ProfileTest.this.r.nextInt(50));
            long d = 0L;
            long st = 0L;
            switch (this.mode) {
                case PUT: {
                    st = System.nanoTime();
                    ProfileTest.this.cache.put(f, (Object)k, (Object)ProfileTest.this.getRandomString());
                    d = System.nanoTime() - st;
                    break;
                }
                case GET: {
                    st = System.nanoTime();
                    ProfileTest.this.cache.get(f, (Object)k);
                    d = System.nanoTime() - st;
                    break;
                }
                case REMOVE: {
                    st = System.nanoTime();
                    ProfileTest.this.cache.remove(f, (Object)k);
                    d = System.nanoTime() - st;
                }
            }
            this.duration.getAndAdd(d);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Mode {
        PUT,
        GET,
        REMOVE;

    }
}

