/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.replicated;

import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeEvent;
import org.jboss.cache.transaction.TransactionSetup;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups", "transaction"})
public class SyncReplTxTest {
    private static Log log = LogFactory.getLog(SyncReplTxTest.class);
    private CacheSPI<Object, Object> cache1;
    private CacheSPI<Object, Object> cache2;
    Semaphore lock;
    private Throwable t1_ex;
    private Throwable t2_ex;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.t2_ex = null;
        this.t1_ex = null;
        this.lock = new Semaphore(1);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TransactionSetup.cleanup();
        this.destroyCaches();
    }

    private TransactionManager beginTransaction() throws SystemException, NotSupportedException {
        return this.beginTransaction(this.cache1);
    }

    private TransactionManager beginTransaction(CacheSPI c) throws SystemException, NotSupportedException {
        TransactionManager mgr = c.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr;
    }

    private void initCaches(Configuration.CacheMode caching_mode) throws Exception {
        this.cache1 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache2 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        this.cache1.getConfiguration().setCacheMode(caching_mode);
        this.cache2.getConfiguration().setCacheMode(caching_mode);
        this.cache1.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache2.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache1.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache2.getConfiguration().setTransactionManagerLookupClass(TransactionSetup.getManagerLookup());
        this.cache1.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.cache2.getConfiguration().setLockAcquisitionTimeout(5000L);
        this.configureMultiplexer((Cache)this.cache1);
        this.configureMultiplexer((Cache)this.cache2);
        this.cache1.start();
        this.cache2.start();
        this.validateMultiplexer((Cache)this.cache1);
        this.validateMultiplexer((Cache)this.cache2);
    }

    protected void configureMultiplexer(Cache cache) throws Exception {
    }

    protected void validateMultiplexer(Cache cache) {
        AssertJUnit.assertFalse((String)"Cache is not using multiplexer", (boolean)cache.getConfiguration().isUsingMultiplexer());
    }

    private void destroyCaches() {
        if (this.cache1 != null) {
            this.cache1.stop();
        }
        if (this.cache2 != null) {
            this.cache2.stop();
        }
        this.cache1 = null;
        this.cache2 = null;
    }

    public void testLockRemoval() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        TestingUtil.extractLockManager(this.cache1).unlockAll(this.cache1.getRoot());
        TransactionManager tm = this.beginTransaction();
        this.cache1.put("/bela/ban", (Object)"name", (Object)"Bela Ban");
        AssertJUnit.assertEquals((int)3, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
        tm.commit();
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
    }

    public void testSyncRepl() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        this.cache2.getConfiguration().setSyncCommitPhase(true);
        TransactionManager mgr = this.beginTransaction();
        this.cache1.put("/a/b/c", (Object)"age", (Object)38);
        Transaction tx = mgr.suspend();
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get("/a/b/c", (Object)"age"));
        log.debug((Object)("cache1: locks held before commit: " + CachePrinter.printCacheLockingInfo(this.cache1)));
        log.debug((Object)("cache2: locks held before commit: " + CachePrinter.printCacheLockingInfo(this.cache2)));
        mgr.resume(tx);
        mgr.commit();
        log.debug((Object)("cache1: locks held after commit: " + CachePrinter.printCacheLockingInfo(this.cache1)));
        log.debug((Object)("cache2: locks held after commit: " + CachePrinter.printCacheLockingInfo(this.cache2)));
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 must be non-null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testSimplePut() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.put("/JSESSION/localhost/192.168.1.10:32882/Courses/0", (Object)"Instructor", (Object)"Ben Wang");
        this.cache1.put("/JSESSION/localhost/192.168.1.10:32882/1", (Object)"Number", (Object)10);
    }

    public void testSimpleTxPut() throws Exception {
        Fqn NODE1 = Fqn.fromString((String)"/one/two/three");
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        TransactionManager tm = this.beginTransaction();
        this.cache1.put(NODE1, (Object)"age", (Object)38);
        System.out.println("TransactionTable for cache1 after cache1.put():\n" + this.cache1.getTransactionTable().toString(true));
        tm.commit();
    }

    public void testSyncReplWithModficationsOnBothCaches() throws Exception {
        Fqn NODE1 = Fqn.fromString((String)"/one/two/three");
        Fqn NODE2 = Fqn.fromString((String)"/eins/zwei/drei");
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.put("/one/two", null);
        this.cache2.put("/eins/zwei", null);
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        this.cache2.getConfiguration().setSyncCommitPhase(true);
        TransactionManager tm = this.beginTransaction();
        this.cache1.put(NODE1, (Object)"age", (Object)38);
        System.out.println("TransactionTable for cache1 after cache1.put():\n" + this.cache1.getTransactionTable().toString(true));
        this.cache2.put(NODE2, (Object)"age", (Object)39);
        System.out.println("TransactionTable for cache2 after cache2.put():\n" + this.cache2.getTransactionTable().toString(true));
        System.out.println("cache1 before commit:\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 before commit:\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        try {
            tm.commit();
            AssertJUnit.fail((String)"Should not succeed with SERIALIZABLE semantics");
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("cache1 after commit:\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 after commit:\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
        System.out.println("TransactionTable for cache1:\n" + this.cache1.getTransactionTable().toString(true));
        System.out.println("TransactionTable for cache2:\n" + this.cache2.getTransactionTable().toString(true));
    }

    public void testSyncReplWithModficationsOnBothCachesSameData() throws Exception {
        Fqn NODE = Fqn.fromString((String)"/one/two/three");
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        TransactionManager tm = this.beginTransaction();
        this.cache1.put(NODE, (Object)"age", (Object)38);
        System.out.println("TransactionTable for cache1 after cache1.put():\n" + this.cache1.getTransactionTable().toString(true));
        this.cache2.put(NODE, (Object)"age", (Object)39);
        System.out.println("TransactionTable for cache2 after cache2.put():\n" + this.cache2.getTransactionTable().toString(true));
        System.out.println("cache1 before commit:\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 before commit:\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        try {
            tm.commit();
            AssertJUnit.fail((String)"commit should throw a RollbackException, we should not get here");
        }
        catch (RollbackException rollback) {
            System.out.println("Transaction was rolled back, this is correct");
        }
        System.out.println("cache1 after commit:\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 after commit:\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfNodes());
    }

    public void testSyncReplWithModficationsOnBothCachesWithRollback() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/one/two/three");
        Fqn fqn2 = Fqn.fromString((String)"/eins/zwei/drei");
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncRollbackPhase(true);
        this.cache2.getConfiguration().setSyncRollbackPhase(true);
        TransactionManager tm = this.beginTransaction();
        this.cache1.put(fqn1, (Object)"age", (Object)38);
        this.cache2.put(fqn2, (Object)"age", (Object)39);
        System.out.println("cache1 (before commit):\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 (before commit):\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        Transaction tx = tm.getTransaction();
        tx.registerSynchronization((Synchronization)new TransactionAborter(tx));
        try {
            tm.commit();
            AssertJUnit.fail((String)"commit should throw a RollbackException, we should not get here");
        }
        catch (RollbackException rollback) {
            System.out.println("Transaction was rolled back, this is correct");
        }
        System.out.println("cache1 (after rollback):\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 (after rollback):\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSyncReplWithRemoteRollback() throws Exception {
        Fqn NODE1 = Fqn.fromString((String)"/one/two/three");
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncRollbackPhase(true);
        this.cache2.getConfiguration().setSyncRollbackPhase(true);
        TransactionManager tm = this.beginTransaction();
        this.cache1.put(NODE1, (Object)"age", (Object)38);
        System.out.println("cache1 (before commit):\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 (before commit):\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        Transaction tx = tm.suspend();
        tm.begin();
        this.cache2.getRoot().put((Object)"x", (Object)"y");
        Transaction tx2 = this.cache2.getTransactionManager().suspend();
        System.out.println("cache2 (before commit):\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        tm.resume(tx);
        try {
            tm.commit();
            AssertJUnit.fail((String)"commit should throw a RollbackException, we should not get here");
        }
        catch (RollbackException rollback) {
            System.out.println("Transaction was rolled back, this is correct");
        }
        finally {
            tm.resume(tx2);
            tm.rollback();
        }
        TestingUtil.sleepThread(1000L);
        System.out.println("cache1 (after rollback):\n" + CachePrinter.printCacheLockingInfo(this.cache1));
        System.out.println("cache2 (after rollback):\n" + CachePrinter.printCacheLockingInfo(this.cache2));
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)this.cache1.getNumberOfNodes());
        AssertJUnit.assertEquals((int)0, (int)this.cache2.getNumberOfNodes());
    }

    public void testASyncRepl() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_ASYNC);
        TransactionManager tm = this.beginTransaction();
        this.cache1.put("/a/b/c", (Object)"age", (Object)38);
        Thread.sleep(1000L);
        AssertJUnit.assertNull((String)"age on cache2 must be null as the TX has not yet been committed", (Object)this.cache2.get("/a/b/c", (Object)"age"));
        tm.commit();
        Thread.sleep(1000L);
        Integer age = (Integer)this.cache2.get("/a/b/c", (Object)"age");
        AssertJUnit.assertNotNull((String)"\"age\" obtained from cache2 is null ", (Object)age);
        AssertJUnit.assertTrue((String)"\"age\" must be 38", (age == 38 ? 1 : 0) != 0);
    }

    public void testConcurrentPuts() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        this.cache1.getConfiguration().setSyncCommitPhase(true);
        Thread t1 = new Thread("Thread1"){
            TransactionManager tm;

            public void run() {
                try {
                    this.tm = SyncReplTxTest.this.beginTransaction();
                    SyncReplTxTest.this.cache1.put("/bela/ban", (Object)"name", (Object)"Bela Ban");
                    TestingUtil.sleepThread(2000L);
                    this.tm.commit();
                    System.out.println("[Thread1] ** LOCK INFO cache1: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache1));
                    System.out.println("[Thread1] ** LOCK INFO cache2: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache2));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t1_ex = ex;
                }
            }
        };
        Thread t2 = new Thread("Thread2"){
            TransactionManager tm;

            public void run() {
                try {
                    TestingUtil.sleepThread(1000L);
                    this.tm = SyncReplTxTest.this.beginTransaction();
                    System.out.println("[Thread2] ** LOCK INFO cache1: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache1));
                    System.out.println("[Thread2] ** LOCK INFO cache2: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache2));
                    SyncReplTxTest.this.cache1.put("/bela/ban", (Object)"name", (Object)"Michelle Ban");
                    System.out.println("[Thread2] ** LOCK INFO cache1: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache1));
                    System.out.println("[Thread2] ** LOCK INFO cache2: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache2));
                    this.tm.commit();
                    System.out.println("[Thread2] ** LOCK INFO cache1: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache1));
                    System.out.println("[Thread2] ** LOCK INFO cache2: " + CachePrinter.printCacheLockingInfo((Cache)SyncReplTxTest.this.cache2));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t2_ex = ex;
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            AssertJUnit.fail((String)("Thread1 failed: " + this.t1_ex));
        }
        if (this.t2_ex != null) {
            AssertJUnit.fail((String)("Thread2 failed: " + this.t2_ex));
        }
        AssertJUnit.assertEquals((Object)"Michelle Ban", (Object)this.cache1.get("/bela/ban", (Object)"name"));
    }

    public void testConcurrentCommitsWith1Thread() throws Exception {
        this._testConcurrentCommits(1);
    }

    public void testConcurrentCommitsWith5Threads() throws Exception {
        this._testConcurrentCommits(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testConcurrentCommits(int num_threads) {
        int i;
        Object myMutex = new Object();
        final CacheSPI c1 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        CacheSPI c2 = (CacheSPI)new DefaultCacheFactory().createCache(false);
        c1.getConfiguration().setClusterName("TempCluster");
        c2.getConfiguration().setClusterName("TempCluster");
        c1.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c2.getConfiguration().setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c1.getConfiguration().setSyncCommitPhase(true);
        c2.getConfiguration().setSyncCommitPhase(true);
        c1.getConfiguration().setSyncRollbackPhase(true);
        c2.getConfiguration().setSyncRollbackPhase(true);
        c1.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c2.getConfiguration().setIsolationLevel(IsolationLevel.REPEATABLE_READ);
        c1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        c1.getConfiguration().setLockAcquisitionTimeout(5000L);
        c2.getConfiguration().setLockAcquisitionTimeout(5000L);
        c1.start();
        c2.start();
        final ArrayList exceptions = new ArrayList();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyThread
        extends Thread {
            final Object mutex;

            public MyThread(String name, Object mutex) {
                super(name);
                this.mutex = mutex;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TransactionManager tm = null;
                try {
                    tm = SyncReplTxTest.this.beginTransaction(c1);
                    c1.put("/thread/" + this.getName(), null);
                    System.out.println("Thread " + this.getName() + " after put(): " + c1.toString());
                    System.out.println("Thread " + this.getName() + " waiting on mutex");
                    Object object = this.mutex;
                    synchronized (object) {
                        this.mutex.wait();
                    }
                    System.out.println("Thread " + this.getName() + " committing");
                    tm.commit();
                    System.out.println("Thread " + this.getName() + " committed successfully");
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
                finally {
                    try {
                        if (tm != null) {
                            tm.rollback();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        MyThread[] threads = new MyThread[num_threads];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new MyThread("#" + i, myMutex);
        }
        for (i = 0; i < threads.length; ++i) {
            MyThread thread = threads[i];
            System.out.println("starting thread #" + i);
            thread.start();
        }
        TestingUtil.sleepThread(6000L);
        Object i2 = myMutex;
        synchronized (i2) {
            System.out.println("cache is " + CachePrinter.printCacheLockingInfo((Cache)c1));
            System.out.println("******************* SIGNALLING THREADS ********************");
            myMutex.notifyAll();
        }
        for (MyThread thread : threads) {
            try {
                thread.join();
                System.out.println("Joined thread " + thread.getName());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("FINAL c1:\n" + CachePrinter.printCacheDetails((Cache)c1) + "\nlocks:\n" + CachePrinter.printCacheLockingInfo((Cache)c1));
        AssertJUnit.assertEquals((int)0, (int)c1.getNumberOfLocksHeld());
        AssertJUnit.assertEquals((int)0, (int)c2.getNumberOfLocksHeld());
        c1.stop();
        c2.stop();
        for (Exception exception : exceptions) {
            AssertJUnit.assertEquals(TimeoutException.class, exception.getClass());
        }
    }

    public void testConcurrentPutsOnTwoInstances() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        final CacheSPI<Object, Object> c1 = this.cache1;
        final CacheSPI<Object, Object> c2 = this.cache2;
        Thread t1 = new Thread(){
            TransactionManager tm;

            public void run() {
                try {
                    this.tm = SyncReplTxTest.this.beginTransaction();
                    c1.put("/ben/wang", (Object)"name", (Object)"Ben Wang");
                    TestingUtil.sleepThread(8000L);
                    this.tm.commit();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t1_ex = ex;
                }
            }
        };
        Thread t2 = new Thread(){
            TransactionManager tm;

            public void run() {
                try {
                    TestingUtil.sleepThread(1000L);
                    this.tm = SyncReplTxTest.this.beginTransaction();
                    c2.put("/ben/wang", (Object)"name", (Object)"Ben Jr.");
                    this.tm.commit();
                }
                catch (RollbackException rollback_ex) {
                    System.out.println("received rollback exception as expected");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t2_ex = ex;
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            AssertJUnit.fail((String)("Thread1 failed: " + this.t1_ex));
        }
        if (this.t2_ex != null) {
            AssertJUnit.fail((String)("Thread2 failed: " + this.t2_ex));
        }
        AssertJUnit.assertEquals((Object)"Ben Wang", (Object)c1.get("/ben/wang", (Object)"name"));
    }

    public void testPut() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        final CacheSPI<Object, Object> c1 = this.cache1;
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SyncReplTxTest.this.lock.acquire();
                    System.out.println("-- t1 has lock");
                    c1.put("/a/b/c", (Object)"age", (Object)38);
                    System.out.println("[Thread1] set value to 38");
                    System.out.println("-- t1 releases lock");
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(300L);
                    Thread.yield();
                    SyncReplTxTest.this.lock.acquire();
                    System.out.println("-- t1 has lock");
                    c1.put("/a/b/c", (Object)"age", (Object)39);
                    System.out.println("[Thread1] set value to 39");
                    System.out.println("-- t1 releases lock");
                    SyncReplTxTest.this.lock.release();
                    AssertJUnit.assertEquals((Object)39, (Object)c1.get("/a/b/c", (Object)"age"));
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t1_ex = ex;
                }
                finally {
                    SyncReplTxTest.this.lock.release();
                }
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    TestingUtil.sleepThread(100L);
                    Thread.yield();
                    SyncReplTxTest.this.lock.acquire();
                    System.out.println("-- t2 has lock");
                    Integer val = (Integer)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age");
                    System.out.println("[Thread2] value is " + val);
                    AssertJUnit.assertEquals((Object)new Integer(38), (Object)val);
                    System.out.println("-- t2 releases lock");
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(300L);
                    Thread.yield();
                    TestingUtil.sleepThread(500L);
                    SyncReplTxTest.this.lock.acquire();
                    System.out.println("-- t2 has lock");
                    val = (Integer)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age");
                    System.out.println("-- t2 releases lock");
                    SyncReplTxTest.this.lock.release();
                    AssertJUnit.assertEquals((Object)new Integer(39), (Object)val);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t2_ex = ex;
                }
                finally {
                    SyncReplTxTest.this.lock.release();
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            AssertJUnit.fail((String)("Thread1 failed: " + this.t1_ex));
        }
        if (this.t2_ex != null) {
            AssertJUnit.fail((String)("Thread2 failed: " + this.t2_ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutTx() throws Exception {
        try {
            this.initCaches(Configuration.CacheMode.REPL_SYNC);
            this.cache1.getConfiguration().setSyncCommitPhase(true);
            this.cache2.getConfiguration().setSyncCommitPhase(true);
            TransactionManager tm = this.beginTransaction();
            this.cache1.put("/a/b/c", (Object)"age", (Object)38);
            this.cache1.put("/a/b/c", (Object)"age", (Object)39);
            Object val = this.cache2.get("/a/b/c", (Object)"age");
            AssertJUnit.assertNull((Object)val);
            tm.commit();
            tm = this.beginTransaction();
            AssertJUnit.assertEquals((Object)39, (Object)this.cache2.get("/a/b/c", (Object)"age"));
            tm.commit();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.t1_ex = t;
        }
        finally {
            this.lock.release();
        }
    }

    public void testPutTx1() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        final CacheSPI<Object, Object> c1 = this.cache1;
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SyncReplTxTest.this.lock.acquire();
                    TransactionManager tm = SyncReplTxTest.this.beginTransaction();
                    c1.put("/a/b/c", (Object)"age", (Object)38);
                    c1.put("/a/b/c", (Object)"age", (Object)39);
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(300L);
                    SyncReplTxTest.this.lock.acquire();
                    try {
                        tm.commit();
                    }
                    catch (RollbackException ex) {
                        System.out.println("[Thread1] received RollbackException, as expected. Rolling back changes");
                    }
                    finally {
                        SyncReplTxTest.this.lock.release();
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t1_ex = ex;
                }
                finally {
                    SyncReplTxTest.this.lock.release();
                }
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    8.sleep(200L);
                    Thread.yield();
                    SyncReplTxTest.this.lock.acquire();
                    TransactionManager tm = SyncReplTxTest.this.beginTransaction();
                    AssertJUnit.assertNull((Object)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age"));
                    SyncReplTxTest.this.cache2.put("/a/b/c", (Object)"age", (Object)40);
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(300L);
                    SyncReplTxTest.this.lock.acquire();
                    AssertJUnit.assertEquals((Object)40, (Object)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age"));
                    tm.commit();
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(1000L);
                    tm = SyncReplTxTest.this.beginTransaction();
                    AssertJUnit.assertEquals((String)"After cache2 commit", (Object)40, (Object)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age"));
                    tm.commit();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t2_ex = ex;
                }
                finally {
                    SyncReplTxTest.this.lock.release();
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            AssertJUnit.fail((String)("Thread1 failed: " + this.t1_ex));
        }
        if (this.t2_ex != null) {
            AssertJUnit.fail((String)("Thread2 failed: " + this.t2_ex));
        }
    }

    public void testPutTxWithRollback() throws Exception {
        this.initCaches(Configuration.CacheMode.REPL_SYNC);
        final CacheSPI<Object, Object> c2 = this.cache1;
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SyncReplTxTest.this.lock.acquire();
                    TransactionManager tm = SyncReplTxTest.this.beginTransaction();
                    c2.put("/a/b/c", (Object)"age", (Object)38);
                    c2.put("/a/b/c", (Object)"age", (Object)39);
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(100L);
                    SyncReplTxTest.this.lock.acquire();
                    tm.rollback();
                    SyncReplTxTest.this.lock.release();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t1_ex = ex;
                }
                finally {
                    SyncReplTxTest.this.lock.release();
                }
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    10.sleep(200L);
                    Thread.yield();
                    SyncReplTxTest.this.lock.acquire();
                    TransactionManager tm = SyncReplTxTest.this.beginTransaction();
                    AssertJUnit.assertNull((Object)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age"));
                    SyncReplTxTest.this.lock.release();
                    TestingUtil.sleepThread(100L);
                    SyncReplTxTest.this.lock.acquire();
                    AssertJUnit.assertNull((Object)SyncReplTxTest.this.cache2.get("/a/b/c", (Object)"age"));
                    tm.commit();
                    SyncReplTxTest.this.lock.release();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    SyncReplTxTest.this.t2_ex = ex;
                }
                finally {
                    SyncReplTxTest.this.lock.release();
                }
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        if (this.t1_ex != null) {
            AssertJUnit.fail((String)("Thread1 failed: " + this.t1_ex));
        }
        if (this.t2_ex != null) {
            AssertJUnit.fail((String)("Thread2 failed: " + this.t2_ex));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TransactionAborterCallbackListener
    extends CallbackListener {
        TransactionManager callbackTM;

        TransactionAborterCallbackListener(CacheSPI<Object, Object> cache, Object callbackKey) {
            super(cache, callbackKey);
            this.callbackTM = this.callbackCache.getTransactionManager();
        }

        @Override
        @NodeModified
        public void nodeModified(NodeEvent ne) {
            block5: {
                if (!ne.isPre()) {
                    try {
                        Transaction tx = this.callbackTM.getTransaction();
                        if (tx != null && tx.getStatus() == 0) {
                            tx.registerSynchronization((Synchronization)new TransactionAborter(tx));
                        } else {
                            super.nodeModified(ne);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (this.ex != null) break block5;
                        this.ex = e;
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CacheListener
    static class CallbackListener {
        CacheSPI<Object, Object> callbackCache;
        Object callbackKey;
        Exception ex;
        final Object mutex = new Object();

        CallbackListener(CacheSPI<Object, Object> cache, Object callbackKey) {
            this.callbackCache = cache;
            this.callbackKey = callbackKey;
            cache.getNotifier().addCacheListener((Object)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NodeModified
        public void nodeModified(NodeEvent e) {
            if (!e.isPre()) {
                Object object = this.mutex;
                synchronized (object) {
                    try {
                        this.callbackCache.get(e.getFqn(), this.callbackKey);
                    }
                    catch (CacheException exc) {
                        exc.printStackTrace();
                        this.ex = exc;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Exception getCallbackException() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ex;
            }
        }
    }

    static class TransactionAborter
    implements Synchronization {
        Transaction ltx = null;

        public TransactionAborter(Transaction ltx) {
            this.ltx = ltx;
        }

        public void beforeCompletion() {
            try {
                this.ltx.setRollbackOnly();
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }

        public void afterCompletion(int status) {
        }
    }
}

