/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util.internals;

import java.lang.reflect.Method;
import java.util.Timer;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionTimerTask;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.util.TestingUtil;

public class EvictionController {
    CacheSPI cache;
    EvictionTimerTask timerTask;

    public EvictionController(Cache cache) {
        this.cache = (CacheSPI)cache;
        RegionManager regionManager = this.cache.getRegionManager();
        if (regionManager == null) {
            throw new IllegalStateException("Null region manager; is the cache started?");
        }
        this.timerTask = (EvictionTimerTask)TestingUtil.extractField(regionManager, "evictionTimerTask");
        if (this.timerTask == null) {
            throw new IllegalStateException("No timer task!!!");
        }
        Timer evictionThread = (Timer)TestingUtil.extractField(this.timerTask, "evictionThread");
        evictionThread.cancel();
    }

    public void startEviction() {
        try {
            Method method = EvictionTimerTask.class.getDeclaredMethod("processRegions", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.timerTask, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void evictRegionWithTimeToLive(String region) throws Exception {
        EvictionConfig evConfig = this.cache.getConfiguration().getEvictionConfig();
        EvictionRegionConfig erConfig = evConfig.getEvictionRegionConfig(region);
        if (erConfig == null) {
            throw new IllegalStateException("No such region!");
        }
        int ttl = 0;
        if (!(erConfig.getEvictionPolicyConfig() instanceof LRUConfiguration)) {
            throw new IllegalArgumentException("Only LRU being handled for now; please add other implementations here");
        }
        LRUConfiguration configuration = (LRUConfiguration)erConfig.getEvictionPolicyConfig();
        ttl = configuration.getTimeToLiveSeconds();
        TestingUtil.sleepThread(ttl * 1000 + 500);
        this.evictRegion(region);
    }

    public void evictRegion(String regionStr) throws Exception {
        for (Region region : this.timerTask.getProcessedRegions()) {
            if (!region.getFqn().equals((Object)Fqn.fromString((String)regionStr))) continue;
            Method method = EvictionTimerTask.class.getDeclaredMethod("handleRegion", Region.class);
            method.setAccessible(true);
            method.invoke((Object)this.timerTask, region);
        }
    }
}

