/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.eviction.ElementSizePolicy;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;

public class ElementSizeConfiguration
extends EvictionPolicyConfigBase {
    private static final long serialVersionUID = 2510593544656833758L;
    @Dynamic
    private int maxElementsPerNode;

    public ElementSizeConfiguration() {
        this.setMaxElementsPerNode(-1);
    }

    protected void setEvictionPolicyClassName() {
        this.setEvictionPolicyClass(ElementSizePolicy.class.getName());
    }

    public int getMaxElementsPerNode() {
        return this.maxElementsPerNode;
    }

    public void setMaxElementsPerNode(int maxElementsPerNode) {
        this.testImmutability("maxElementsPerNode");
        this.maxElementsPerNode = maxElementsPerNode;
    }

    public void validate() throws ConfigurationException {
        if (this.maxElementsPerNode < 0) {
            throw new ConfigurationException("maxElementsPerNode must be must be configured to a value greater than or equal to 0");
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ElementSizeConfiguration: maxElementsPerNode =");
        str.append(this.getMaxElementsPerNode()).append(" maxNodes =").append(this.getMaxNodes());
        return str.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            return this.maxElementsPerNode == ((ElementSizeConfiguration)obj).maxElementsPerNode;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.maxElementsPerNode;
        return result;
    }

    public void reset() {
        super.reset();
        this.setMaxElementsPerNode(-1);
    }

    public ElementSizeConfiguration clone() throws CloneNotSupportedException {
        return (ElementSizeConfiguration)super.clone();
    }
}

