/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.NotSerializableException;
import java.util.Vector;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.commands.VisitableCommand;
import org.jboss.cache.commands.remote.AnnounceBuddyPoolNameCommand;
import org.jboss.cache.commands.remote.AssignToBuddyGroupCommand;
import org.jboss.cache.commands.remote.RemoveFromBuddyGroupCommand;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAwareRpcDispatcher
extends RpcDispatcher {
    protected InvocationContextContainer invocationContextContainer;
    protected InterceptorChain interceptorChain;
    protected ComponentRegistry componentRegistry;
    protected boolean trace;

    public CommandAwareRpcDispatcher() {
    }

    public CommandAwareRpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object serverObj, InvocationContextContainer container, InterceptorChain interceptorChain, ComponentRegistry componentRegistry) {
        super(channel, l, l2, serverObj);
        this.invocationContextContainer = container;
        this.componentRegistry = componentRegistry;
        this.interceptorChain = interceptorChain;
        this.trace = this.log.isTraceEnabled();
    }

    protected boolean isValid(Message req) {
        if (this.server_obj == null) {
            this.log.error((Object)"no method handler is registered. Discarding request.");
            return false;
        }
        if (req == null || req.getLength() == 0) {
            this.log.error((Object)"message or message buffer is null");
            return false;
        }
        return true;
    }

    public RspList invokeRemoteCommands(Vector<Address> dests, ReplicableCommand command, int mode, long timeout, boolean use_anycasting, boolean oob, RspFilter filter) throws NotSerializableException {
        byte[] buf;
        if (dests != null && dests.isEmpty()) {
            if (this.trace) {
                this.log.trace((Object)"Destination list is empty: no need to send message");
            }
            return new RspList();
        }
        if (this.trace) {
            this.log.trace((Object)new StringBuilder("dests=").append(dests).append(", command=").append(command).append(", mode=").append(mode).append(", timeout=").append(timeout));
        }
        try {
            buf = this.getRequestMarshaller().objectToByteBuffer((Object)command);
        }
        catch (Exception e) {
            throw new RuntimeException("failure to marshal argument(s)", e);
        }
        Message msg = new Message(null, null, buf);
        if (oob) {
            msg.setFlag((byte)1);
        }
        RspList retval = super.castMessage(dests, msg, mode, timeout, use_anycasting, filter);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("responses: " + retval));
        }
        if (retval == null) {
            throw new NotSerializableException("RpcDispatcher returned a null.  This is most often caused by args for " + command.getClass().getSimpleName() + " not being serializable.");
        }
        if (mode == 6 || retval.isEmpty() || this.containsOnlyNulls(retval)) {
            return null;
        }
        return retval;
    }

    private boolean containsOnlyNulls(RspList l) {
        for (Rsp r : l.values()) {
            if (r.getValue() == null && r.wasReceived() && !r.wasSuspected()) continue;
            return false;
        }
        return true;
    }

    public Object handle(Message req) {
        if (this.isValid(req)) {
            try {
                return this.executeCommand((ReplicableCommand)this.getRequestMarshaller().objectFromByteBuffer(req.getBuffer()), req);
            }
            catch (Throwable x) {
                if (this.trace) {
                    this.log.trace((Object)"Problems invoking command.", x);
                }
                return x;
            }
        }
        return null;
    }

    protected Object executeCommand(ReplicableCommand cmd, Message req) throws Throwable {
        if (this.trace) {
            this.log.trace((Object)("Executing command: " + cmd + " [sender=" + req.getSrc() + "]"));
        }
        if (cmd instanceof VisitableCommand) {
            InvocationContext ctx = (InvocationContext)this.invocationContextContainer.get();
            ctx.setOriginLocal(false);
            if (!this.componentRegistry.invocationsAllowed(false)) {
                return null;
            }
            return this.interceptorChain.invoke(ctx, (VisitableCommand)cmd);
        }
        if (this.trace) {
            this.log.trace((Object)"This is a non-visitable command - so performing directly and not via the invoker.");
        }
        if (!(cmd instanceof AnnounceBuddyPoolNameCommand || cmd instanceof AssignToBuddyGroupCommand || cmd instanceof RemoveFromBuddyGroupCommand || this.componentRegistry.invocationsAllowed(false))) {
            return null;
        }
        return cmd.perform(null);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[Outgoing marshaller: " + this.getRequestMarshaller() + "; incoming marshaller: " + this.getResponseMarshaller() + "]";
    }
}

