package org.jboss.cache.pojo.util;

import static org.testng.AssertJUnit.assertFalse;
import static org.testng.AssertJUnit.assertTrue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.test.NodeManager;
import org.jboss.cache.pojo.test.TestNode;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;


/**
 * Test case for ObjectUtil
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class ObjectUtilTest 
{
   Log log_ = LogFactory.getLog(ObjectUtilTest.class);
   PojoCache cache_;


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      boolean toStart = false;
      cache_ = PojoCacheFactory.createCache(configFile, toStart);
      cache_.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
   }

//   public void testDummy() {}

   public void testIsReachable() throws Exception
   {
      log_.info("testIsReachable() ....");
      NodeManager pm_ = new NodeManager();

      pm_.setRootNode("root");
      pm_.addNode("root", "kanto");
      pm_.addNode("root.kanto", "tokyo");
      pm_.addNode("root.kanto", "yakahoma");
      pm_.addNode("root.kanto.tokyo", "handanshita");

      TestNode kanto = pm_.findNode("root.kanto");
      TestNode yakahoma = pm_.findNode("root.kanto.yakahoma");
      TestNode hadanshita = pm_.findNode("root.kanto.tokyo.handanshita");

      pm_ = new NodeManager();
      pm_.setRootNode("rt");
      pm_.addNode("rt", "test");
      TestNode test = pm_.findNode("rt.test");

//      cache_.putObject("/pm", pm_);

      assertTrue("Hadanshita should be reachable from Kanto ",
              ObjectUtil.isReachable((PojoCacheImpl)cache_, kanto, hadanshita));
      assertTrue("Hadanshita should also be reachable from Yakahoma! ",
              ObjectUtil.isReachable((PojoCacheImpl) cache_, yakahoma, hadanshita));
      assertFalse("Kanto should not be reachable from test! ",
              ObjectUtil.isReachable((PojoCacheImpl) cache_, kanto, test));
   }




}

