/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class StructuralNodesOnRollbackTest {
    private CacheSPI<Object, Object> cache;
    private TransactionManager txMgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, false);
        this.cache = (CacheSPI)new DefaultCacheFactory().createCache(cacheConfig, false);
        this.cache.start();
        this.txMgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.cache.stop();
        this.cache.destroy();
    }

    public void testPutDataMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k", "v");
        assert (!this.cache.exists("/a/b"));
        this.txMgr.begin();
        this.cache.put("/a/b/c", map);
        assert (this.cache.exists("/a/b"));
        this.txMgr.rollback();
        assert (!this.cache.exists("/a/b"));
    }

    public void testPutKeyValueCommand() throws Exception {
        assert (!this.cache.exists("/a/b"));
        this.txMgr.begin();
        this.cache.put("/a/b/c", (Object)"key", (Object)"value");
        assert (this.cache.exists("/a/b"));
        this.txMgr.rollback();
        assert (!this.cache.exists("/a/b"));
    }
}

