/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.Set;
import org.easymock.EasyMock;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.mock.MockNodesFixture;
import org.jboss.cache.mock.NodeSpiMock;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class GetChildrenNamesCommandTest
extends AbstractDataCommandTest {
    private GetChildrenNamesCommand command;
    private MockNodesFixture nodes;

    protected void moreSetup() {
        this.nodes = new MockNodesFixture();
        this.command = new GetChildrenNamesCommand(this.testFqn);
        this.command.initialize(this.container);
    }

    public void testPerformNoChildren() {
        NodeSpiMock node = new NodeSpiMock(this.testFqn);
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{this.container});
        Set result = (Set)this.command.perform(null);
        assert (result.isEmpty()) : "empty result expected";
    }

    public void testPerformInexistingNode() {
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.container});
        Set result = (Set)this.command.perform(null);
        assert (result == null) : "empty result expected";
    }

    public void testNodeWithChildren() {
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.replay((Object[])new Object[]{this.container});
        Set result = (Set)this.command.perform(null);
        assert (result.size() == 2);
        assert (result.contains("h"));
        assert (result.contains("g"));
    }

    public void testNodeInvalidChildren() {
        this.nodes.adfgNode.markAsDeleted(true);
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.replay((Object[])new Object[]{this.container});
        Set result = (Set)this.command.perform(null);
        assert (result.size() == 1);
        assert (result.contains("h"));
    }
}

