/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.HashSet;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"})
public class ChannelInjectionTest {
    private Set<Cache<String, String>> caches = new HashSet<Cache<String, String>>();

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        for (Cache<String, String> cache : this.caches) {
            try {
                cache.stop();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public void testChannelInjectionPreference() throws Exception {
        Cache<String, String> cache1 = this.createCache();
        Cache<String, String> cache2 = this.createCache();
        JChannel ch1 = new JChannel("udp.xml");
        cache1.getConfiguration().getRuntimeConfig().setChannel((Channel)ch1);
        JChannel ch2 = new JChannel("udp.xml");
        cache2.getConfiguration().getRuntimeConfig().setChannel((Channel)ch2);
        cache1.start();
        cache2.start();
        TestingUtil.blockUntilViewsReceived(new Cache[]{cache1, cache2}, 10000L);
        Fqn fqn = Fqn.fromString((String)"/a");
        cache1.put(fqn, (Object)"key", (Object)"value");
        AssertJUnit.assertEquals((String)"Value replicated", (String)"value", (String)((String)cache2.get(fqn, (Object)"key")));
    }

    private Cache<String, String> createCache() {
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        DefaultCacheFactory factory = new DefaultCacheFactory();
        Cache cache = factory.createCache(config, false);
        this.caches.add((Cache<String, String>)cache);
        return cache;
    }
}

