/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.transaction.TransactionSetup;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups", "transaction"})
public class ConfigurationTest {
    public void testReplSyncStack() throws Exception {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_SYNC);
        AssertJUnit.assertEquals((Object)Configuration.CacheMode.REPL_SYNC, (Object)conf.getCacheMode());
        AssertJUnit.assertEquals((String)TransactionSetup.getManagerLookup(), (String)conf.getTransactionManagerLookupClass());
        AssertJUnit.assertEquals((Object)IsolationLevel.REPEATABLE_READ, (Object)conf.getIsolationLevel());
        AssertJUnit.assertEquals((boolean)false, (boolean)conf.isUseReplQueue());
        AssertJUnit.assertEquals((long)0L, (long)conf.getReplQueueInterval());
        AssertJUnit.assertEquals((int)0, (int)conf.getReplQueueMaxElements());
        AssertJUnit.assertEquals((String)"JBossCache-Cluster", (String)conf.getClusterName());
        AssertJUnit.assertEquals((boolean)true, (boolean)conf.isFetchInMemoryState());
        AssertJUnit.assertEquals((long)15000L, (long)conf.getStateRetrievalTimeout());
        AssertJUnit.assertEquals((long)15000L, (long)conf.getSyncReplTimeout());
        AssertJUnit.assertEquals((long)10000L, (long)conf.getLockAcquisitionTimeout());
        AssertJUnit.assertNull((Object)conf.getEvictionConfig());
        AssertJUnit.assertEquals((boolean)false, (boolean)conf.isUseRegionBasedMarshalling());
    }

    public void testMultiplexerStack() throws Exception {
        XmlConfigurationParser parser = new XmlConfigurationParser();
        Configuration conf = parser.parseFile("META-INF/conf-test/mux-service.xml");
        AssertJUnit.assertEquals((String)"MultiplexerStack", (String)"tcp", (String)conf.getMultiplexerStack());
        AssertJUnit.assertNull((String)"ClusterConfig", (Object)conf.getClusterConfig());
    }
}

