/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.DummyEvictionPolicy;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LRUAlgorithm;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LRUAlgorithmTest {
    RegionManager regionManager;
    LRUAlgorithm algorithm;
    LRUConfiguration config;
    Log log = LogFactory.getLog(LRUAlgorithm.class);

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.algorithm = new LRUAlgorithm();
        this.config = new LRUConfiguration();
        this.config.setEvictionPolicyClass(DummyEvictionPolicy.class.getName());
        this.config.setTimeToLiveSeconds(0);
        this.regionManager = new RegionManager();
        this.regionManager.getRegion("/a/b", true).setEvictionPolicy((EvictionPolicyConfig)this.config);
    }

    public void testEvictException() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxNode1() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxNode2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testIdleTimeSeconds1() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setTimeToLiveSeconds(0);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        TestingUtil.sleepThread(500L);
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size should be ", (int)2, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testIdleTimeSeconds2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setTimeToLiveSeconds(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(1100L);
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)0, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testIdleTimeSeconds3() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setTimeToLiveSeconds(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(1100L);
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.VISIT_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)1, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxAgeSeconds1() throws Exception {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setTimeToLiveSeconds(0);
        config.setMaxAgeSeconds(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(1100L);
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)0, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testMaxAgeSeconds2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(0);
        config.setTimeToLiveSeconds(0);
        config.setMaxAgeSeconds(1);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #1: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(500L);
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #2: ", (int)3, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
        TestingUtil.sleepThread(600L);
        this.algorithm.process(region);
        AssertJUnit.assertEquals((String)"Queue size #3: ", (int)0, (int)this.algorithm.getEvictionQueue().getNumberOfNodes());
    }

    public void testCombo1() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Fqn fqn4 = Fqn.fromString((String)"/a/b/f");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(2);
        config.setTimeToLiveSeconds(1);
        config.setMaxAgeSeconds(3);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn4, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        EvictionQueue eq = this.algorithm.getEvictionQueue();
        int numNodesInQueue = eq.getNumberOfNodes();
        assert (2 == numNodesInQueue) : "Queue size #1: expected 2 but was " + numNodesInQueue;
        TestingUtil.sleepThread(1100L);
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        numNodesInQueue = eq.getNumberOfNodes();
        assert (1 == numNodesInQueue) : "Queue size #2: expected 1 but was " + numNodesInQueue;
        TestingUtil.sleepThread(3100L);
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.VISIT_NODE_EVENT));
        this.algorithm.process(region);
        numNodesInQueue = eq.getNumberOfNodes();
        assert (0 == numNodesInQueue) : "Queue size #3: expected 0 but was " + numNodesInQueue;
    }

    public void testCombo2() throws EvictionException {
        Fqn fqn1 = Fqn.fromString((String)"/a/b/c");
        Fqn fqn2 = Fqn.fromString((String)"/a/b/d");
        Fqn fqn3 = Fqn.fromString((String)"/a/b/e");
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxNodes(2);
        config.setTimeToLiveSeconds(1);
        config.setMaxAgeSeconds(3);
        region.putNodeEvent(new EvictedEventNode(fqn1, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.REMOVE_NODE_EVENT));
        this.algorithm.process(region);
        EvictionQueue eq = this.algorithm.getEvictionQueue();
        int numNodesInQueue = eq.getNumberOfNodes();
        assert (1 == numNodesInQueue) : "Queue size #1: expected 1 but was " + numNodesInQueue;
        TestingUtil.sleepThread(1100L);
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.ADD_NODE_EVENT));
        this.algorithm.process(region);
        numNodesInQueue = eq.getNumberOfNodes();
        assert (1 == numNodesInQueue) : "Queue size #2: expected 1 but was " + numNodesInQueue;
        TestingUtil.sleepThread(3100L);
        region.putNodeEvent(new EvictedEventNode(fqn3, NodeEventType.VISIT_NODE_EVENT));
        this.algorithm.process(region);
        numNodesInQueue = eq.getNumberOfNodes();
        assert (0 == numNodesInQueue) : "Queue size #3: expected 0 but was " + numNodesInQueue;
    }

    public void testEvictionSortOrder() throws EvictionException {
        NodeEntry ne;
        Fqn fqn;
        int i;
        Region region = this.regionManager.getRegion("/a/b", true);
        LRUConfiguration config = (LRUConfiguration)region.getEvictionPolicyConfig();
        config.setMaxAgeSeconds(1000);
        config.setMaxNodes(0);
        config.setTimeToLiveSeconds(1000);
        for (i = 0; i < 100; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT));
        }
        this.algorithm.process(region);
        for (i = 0; i < 100; ++i) {
            fqn = Fqn.fromString((String)("/a/b/" + Integer.toString(i)));
            if (i % 2 != 0) continue;
            region.putNodeEvent(new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT));
        }
        this.algorithm.process(region);
        LRUQueue queue = (LRUQueue)this.algorithm.getEvictionQueue();
        int count = 0;
        while ((ne = queue.getFirstLRUNodeEntry()) != null) {
            if (count < 50) {
                AssertJUnit.assertEquals((int)1, (int)ne.getNumberOfNodeVisits());
            } else {
                AssertJUnit.assertEquals((int)2, (int)ne.getNumberOfNodeVisits());
            }
            queue.removeNodeEntry(ne);
            ++count;
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            Fqn fqn2 = Fqn.fromString((String)("/a/b/" + Integer.toString(i2)));
            region.putNodeEvent(new EvictedEventNode(fqn2, NodeEventType.ADD_NODE_EVENT));
        }
        this.algorithm.process(region);
        long lastCreateTimestamp = 0L;
        while ((ne = queue.getFirstMaxAgeNodeEntry()) != null) {
            AssertJUnit.assertTrue((ne.getCreationTimeStamp() >= lastCreateTimestamp ? 1 : 0) != 0);
            lastCreateTimestamp = ne.getCreationTimeStamp();
            queue.removeNodeEntry(ne);
        }
    }

    void log(String msg) {
        System.out.println("-- " + msg);
    }
}

