/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import java.io.Serializable;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.xml.XmlHelper;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional"})
public class ProgrammaticLRUPolicyTest {
    CacheSPI<Object, Object> cache_;
    int wakeupIntervalMillis_ = 0;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.initCaches();
        this.wakeupIntervalMillis_ = this.cache_.getConfiguration().getEvictionConfig().getWakeupIntervalSeconds() * 1000;
        this.log("wakeupInterval is " + this.wakeupIntervalMillis_);
        if (this.wakeupIntervalMillis_ < 0) {
            AssertJUnit.fail((String)("testEviction(): eviction thread wake up interval is illegal " + this.wakeupIntervalMillis_));
        }
    }

    private void initCaches() {
        Configuration conf = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, true);
        DefaultCacheFactory instance = new DefaultCacheFactory();
        this.cache_ = (CacheSPI)instance.createCache(conf, false);
        conf.getEvictionConfig().setWakeupIntervalSeconds(5);
        this.cache_.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache_.getConfiguration().setIsolationLevel(IsolationLevel.SERIALIZABLE);
        this.cache_.create();
        this.cache_.start();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.cache_.stop();
    }

    private void addStringBasedRegion() throws Exception {
        String xml = "<region name=\"/dummy\"><attribute name=\"maxNodes\">10000</attribute><attribute name=\"timeToLiveSeconds\">4</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        RegionManager regionManager = this.cache_.getRegionManager();
        EvictionConfig topConfig = this.cache_.getConfiguration().getEvictionConfig();
        EvictionRegionConfig erc = XmlConfigurationParser.parseEvictionRegionConfig((Element)element, (String)topConfig.getDefaultEvictionPolicyClass(), (int)topConfig.getDefaultEventQueueSize());
        regionManager.setEvictionConfig(topConfig);
        regionManager.getRegion("/programmatic", true).setEvictionPolicy(erc.getEvictionPolicyConfig());
    }

    public void testStringBasedFqnEviction() throws Exception {
        this.addStringBasedRegion();
        String rootStr = "/programmatic/";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr + i;
            Fqn fqn = Fqn.fromString((String)str);
            this.cache_.put(fqn, (Object)str, (Object)str);
        }
        String val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNotNull((String)"DataNode should be empty ", (Object)val);
        System.out.println(this.cache_.toString());
        TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_ + 500);
        System.out.println(this.cache_.toString());
        val = (String)this.cache_.get(rootStr + "3", (Object)(rootStr + "3"));
        AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
    }

    private void addObjectBasedRegion() throws Exception {
        String xml = "<region name=\"/dummy\"><attribute name=\"maxNodes\">10000</attribute><attribute name=\"timeToLiveSeconds\">4</attribute></region>";
        Element element = XmlHelper.stringToElement((String)xml);
        RegionManager regionManager = this.cache_.getRegionManager();
        EvictionConfig topEC = this.cache_.getConfiguration().getEvictionConfig();
        EvictionRegionConfig erc = XmlConfigurationParser.parseEvictionRegionConfig((Element)element, (String)topEC.getDefaultEvictionPolicyClass(), (int)topEC.getDefaultEventQueueSize());
        Integer ii = 1;
        Fqn fqn = Fqn.fromElements((Object[])new Integer[]{ii});
        regionManager.getRegion(fqn, true).setEvictionPolicy(erc.getEvictionPolicyConfig());
    }

    public void testObjectBasedFqnEviction1() throws Exception {
        String val;
        this.addStringBasedRegion();
        String rootStr = "programmatic";
        for (int i = 0; i < 10; ++i) {
            String str = rootStr;
            Integer in = i;
            Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{rootStr, in});
            try {
                this.cache_.put(fqn, (Object)str, (Object)str);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        Integer in = 3;
        Fqn fqn = Fqn.fromElements((Object[])new Serializable[]{rootStr, in});
        try {
            val = (String)this.cache_.get(fqn, (Object)in);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
        System.out.println(this.cache_.toString());
        TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_ + 500);
        System.out.println(this.cache_.toString());
        try {
            val = (String)this.cache_.get(fqn, (Object)in);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    public void testObjectBasedFqnEviction2() throws Exception {
        Object val;
        Fqn fqn;
        Integer in;
        this.addObjectBasedRegion();
        Integer ii = 1;
        Fqn rootfqn = Fqn.fromElements((Object[])new Integer[]{ii});
        for (int i = 0; i < 10; ++i) {
            Integer in2 = i;
            Fqn fqn2 = Fqn.fromRelativeElements((Fqn)rootfqn, (Object[])new Object[]{in2});
            try {
                this.cache_.put(fqn2, (Object)in2, (Object)in2);
                continue;
            }
            catch (Exception e) {
                AssertJUnit.fail((String)("Failed to insert data" + e));
                e.printStackTrace();
            }
        }
        try {
            in = 3;
            fqn = Fqn.fromRelativeElements((Fqn)rootfqn, (Object[])new Object[]{in});
            val = this.cache_.get(fqn, (Object)in);
            AssertJUnit.assertNotNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
        System.out.println(this.cache_.toString());
        TestingUtil.sleepThread(2 * this.wakeupIntervalMillis_ + 500);
        System.out.println(this.cache_.toString());
        try {
            in = 3;
            fqn = Fqn.fromRelativeElements((Fqn)rootfqn, (Object[])new Object[]{in});
            val = this.cache_.get(fqn, (Object)in);
            AssertJUnit.assertNull((String)"DataNode should be empty ", (Object)val);
        }
        catch (Exception e) {
            e.printStackTrace();
            AssertJUnit.fail((String)("Failed to get" + e));
        }
    }

    private void log(String msg) {
        System.out.println("-- " + msg);
    }
}

