/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.AbstractCacheLoaderTestBase;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class CacheLoaderWithReplicationTest
extends AbstractCacheLoaderTestBase {
    private Cache<Object, Object> cache1;
    private Cache<Object, Object> cache2;
    private Fqn fqn = Fqn.fromString((String)"/a");
    private String key = "key";
    private CacheLoader loader1;
    private CacheLoader loader2;
    private TransactionManager mgr1;
    private TransactionManager mgr2;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.cache1 = new DefaultCacheFactory().createCache(false);
        this.cache1.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.DummyInMemoryCacheLoader", null, false, true, false));
        this.cache1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.cache2 = new DefaultCacheFactory().createCache(false);
        this.cache2.getConfiguration().setCacheLoaderConfig(this.getSingleCacheLoaderConfig("", "org.jboss.cache.loader.DummyInMemoryCacheLoader", null, false, true, false));
        this.cache2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        this.loader2 = null;
        this.loader1 = null;
        this.mgr2 = null;
        this.mgr1 = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        if (this.cache1 != null) {
            try {
                try {
                    if (this.mgr1 != null) {
                        this.mgr1.rollback();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.loader1.remove(this.fqn);
                    this.cache1.removeNode(this.fqn);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.cache1.stop();
                this.cache1.destroy();
            }
            finally {
                this.cache1 = null;
                this.mgr1 = null;
                this.loader1 = null;
            }
        }
        if (this.cache2 != null) {
            try {
                try {
                    if (this.mgr2 != null) {
                        this.mgr2.rollback();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.loader2.remove(this.fqn);
                    this.cache2.removeNode(this.fqn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cache2.stop();
                this.cache2.destroy();
            }
            finally {
                this.cache2 = null;
                this.mgr2 = null;
                this.loader2 = null;
            }
        }
    }

    private void createCaches(boolean sync, boolean optimistic) throws Exception {
        this.cache1.getConfiguration().setCacheMode(sync ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC);
        this.cache2.getConfiguration().setCacheMode(sync ? Configuration.CacheMode.REPL_SYNC : Configuration.CacheMode.REPL_ASYNC);
        if (sync) {
            this.cache1.getConfiguration().setSyncCommitPhase(true);
            this.cache2.getConfiguration().setSyncCommitPhase(true);
            this.cache1.getConfiguration().setSyncRollbackPhase(true);
            this.cache2.getConfiguration().setSyncRollbackPhase(true);
        }
        if (optimistic) {
            this.cache1.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
            this.cache2.getConfiguration().setNodeLockingScheme(Configuration.NodeLockingScheme.OPTIMISTIC);
        }
        this.cache1.start();
        this.cache2.start();
        TestingUtil.blockUntilViewsReceived(10000L, this.cache1, this.cache2);
        this.loader1 = ((CacheSPI)this.cache1).getCacheLoaderManager().getCacheLoader();
        this.loader2 = ((CacheSPI)this.cache2).getCacheLoaderManager().getCacheLoader();
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        AssertJUnit.assertNull((Object)this.cache1.getRoot().getChild(this.fqn));
        AssertJUnit.assertNull((Object)this.cache2.getRoot().getChild(this.fqn));
        this.mgr1 = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        this.mgr2 = this.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
    }

    public void testPessSyncRepl() throws Exception {
        this.createCaches(true, false);
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        this.mgr1.commit();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.rollback();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
    }

    public void testPessAsyncRepl() throws Exception {
        this.createCaches(false, false);
        ReplicationListener replListener = new ReplicationListener(this.cache2);
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        replListener.expect(PrepareCommand.class);
        this.mgr1.commit();
        replListener.waitForReplicationToOccur(500L);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.rollback();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
    }

    public void testOptSyncRepl() throws Exception {
        this.createCaches(true, true);
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        this.mgr1.commit();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.rollback();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
    }

    public void testOptAsyncRepl() throws Exception {
        this.createCaches(false, true);
        ReplicationListener replListener = new ReplicationListener(this.cache2);
        this.mgr1.begin();
        replListener.expect(CommitCommand.class);
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value");
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertNull((Object)this.loader1.get(this.fqn));
        AssertJUnit.assertNull((Object)this.loader2.get(this.fqn));
        this.mgr1.commit();
        replListener.waitForReplicationToOccur(500L);
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.begin();
        this.cache1.put(this.fqn, (Object)this.key, (Object)"value2");
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
        this.mgr1.rollback();
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache1.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", (Object)this.cache2.get(this.fqn, (Object)this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader1.get(this.fqn).get(this.key));
        AssertJUnit.assertEquals((Object)"value", this.loader2.get(this.fqn).get(this.key));
    }
}

