/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LockParentRootFlagTest {
    public void testPessimisticSet() {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, true);
    }

    public void testPessimisticUnset() {
        this.doTest(Configuration.NodeLockingScheme.PESSIMISTIC, false);
    }

    public void testOptimisticSet() {
        this.doTest(Configuration.NodeLockingScheme.OPTIMISTIC, true);
    }

    public void testOptimisticUnset() {
        this.doTest(Configuration.NodeLockingScheme.OPTIMISTIC, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTest(Configuration.NodeLockingScheme nls, boolean set) {
        Cache c = null;
        try {
            c = new DefaultCacheFactory().createCache(false);
            c.getConfiguration().setNodeLockingScheme(nls);
            c.getConfiguration().setLockParentForChildInsertRemove(set);
            c.start();
            assert (c.getRoot().isLockForChildInsertRemove() == set);
        }
        catch (Throwable throwable) {
            TestingUtil.killCaches(c);
            throw throwable;
        }
        TestingUtil.killCaches(c);
    }
}

