/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.lang.reflect.Method;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.marshall.FooClassLoader;
import org.jboss.cache.marshall.RegionBasedMarshallingTestBase;
import org.jboss.cache.marshall.data.Address;
import org.jboss.cache.marshall.data.Person;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups"})
public class AsyncReplTest
extends RegionBasedMarshallingTestBase {
    CacheSPI<Object, Object> cache1;
    CacheSPI<Object, Object> cache2;
    String props = null;
    Person ben;
    Address addr;
    Throwable ex;
    private Fqn<String> aop = Fqn.fromString((String)"/aop");
    protected boolean useMarshalledValues = false;
    ReplicationListener replListener1;
    ReplicationListener replListener2;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.resetContextClassLoader();
        this.log("creating cache1");
        this.cache1 = this.createCache("TestCache");
        this.log("creating cache2");
        this.cache2 = this.createCache("TestCache");
        this.replListener1 = new ReplicationListener((Cache)this.cache1);
        this.replListener2 = new ReplicationListener((Cache)this.cache2);
        this.addr = new Address();
        this.addr.setCity("San Jose");
        this.ben = new Person();
        this.ben.setName("Ben");
        this.ben.setAddress(this.addr);
        TestingUtil.blockUntilViewsReceived(new CacheSPI[]{this.cache1, this.cache2}, 60000L);
    }

    private CacheSPI<Object, Object> createCache(String name) {
        CacheSPI cache = (CacheSPI)new DefaultCacheFactory().createCache(UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.REPL_ASYNC), false);
        cache.getConfiguration().setClusterName(name);
        cache.getConfiguration().setUseLazyDeserialization(this.useMarshalledValues);
        cache.getConfiguration().setUseRegionBasedMarshalling(!this.useMarshalledValues);
        cache.create();
        cache.start();
        return cache;
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        TestingUtil.killCaches(new Cache[]{this.cache1, this.cache2});
        this.resetContextClassLoader();
    }

    public void testCLSet2() throws Exception {
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region existing = this.cache1.getRegion(this.aop, true);
            existing.registerContextClassLoader(cla);
            existing = this.cache2.getRegion(this.aop, true);
            existing.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        this.replListener2.expect(PutKeyValueCommand.class);
        this.cache1.put(this.aop, (Object)"person", (Object)this.ben);
        this.replListener2.waitForReplicationToOccur(500L);
        this.replListener2.expect(PutKeyValueCommand.class);
        this.cache1.put(Fqn.fromString((String)"/alias"), (Object)"person", (Object)this.ben);
        this.replListener2.waitForReplicationToOccur(500L);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        Object ben2 = null;
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        ben2 = this.cache2.get(this.aop, (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertNotNull((Object)ben2);
        AssertJUnit.assertEquals((String)this.ben.toString(), (String)ben2.toString());
        Class<?> claz = clb.loadClass("org.jboss.cache.marshall.data.Address");
        Object add = claz.newInstance();
        Method setValue = claz.getMethod("setCity", String.class);
        setValue.invoke(add, "Sunnyvale");
        Class<?> clasz1 = clb.loadClass("org.jboss.cache.marshall.data.Person");
        setValue = clasz1.getMethod("setAddress", claz);
        setValue.invoke(ben2, add);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        this.replListener1.expect(PutKeyValueCommand.class);
        this.cache2.put(this.aop, (Object)"person", ben2);
        this.replListener1.waitForReplicationToOccur(1000L);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        Object ben3 = this.cache1.get(this.aop, (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertEquals((String)ben2.toString(), (String)ben3.toString());
    }

    public void testPuts() throws Exception {
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = this.cache1.getRegion(this.aop, false) == null ? this.cache1.getRegion(this.aop, true) : this.cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = this.cache2.getRegion(this.aop, false) == null ? this.cache2.getRegion(this.aop, true) : this.cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        Object scopedBen1 = this.getPersonFromClassloader(cla);
        Object scopedBen2 = this.getPersonFromClassloader(clb);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        this.replListener2.expect(PutKeyValueCommand.class);
        this.cache1.put(Fqn.fromString((String)"/aop/1"), (Object)"person", (Object)this.ben);
        this.replListener2.waitForReplicationToOccur(1000L);
        this.replListener2.expect(PutKeyValueCommand.class);
        this.cache1.put(Fqn.fromString((String)"/aop/2"), (Object)"person", scopedBen1);
        this.replListener2.waitForReplicationToOccur(1000L);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        Object ben2 = null;
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        ben2 = this.cache2.get(Fqn.fromString((String)"/aop/1"), (Object)"person");
        AssertJUnit.assertEquals((String)this.ben.toString(), (String)ben2.toString());
        ben2 = this.cache2.get(Fqn.fromString((String)"/aop/2"), (Object)"person");
        AssertJUnit.assertFalse((String)"cache2 deserialized with scoped classloader", (boolean)(ben2 instanceof Person));
        AssertJUnit.assertFalse((String)"cache2 deserialized with cache2 classloader", (boolean)scopedBen1.equals(ben2));
        AssertJUnit.assertEquals((String)"scopedBen deserialized properly", (Object)scopedBen2, (Object)ben2);
    }

    public void testTxPut() throws Exception {
        this.replListener2.expectAny();
        this.beginTransaction();
        this.cache1.put(this.aop, (Object)"person", (Object)this.ben);
        this.commit();
        this.replListener2.waitForReplicationToOccur(1000L);
        Person ben2 = (Person)this.cache2.get(this.aop, (Object)"person");
        AssertJUnit.assertNotNull((String)"Person from 2nd cache should not be null ", (Object)ben2);
        AssertJUnit.assertEquals((String)this.ben.toString(), (String)ben2.toString());
    }

    public void testTxCLSet2() throws Exception {
        ClassLoader cla = this.getClassLoader();
        ClassLoader clb = this.getClassLoader();
        if (!this.useMarshalledValues) {
            Region r1 = this.cache1.getRegion(this.aop, false) == null ? this.cache1.getRegion(this.aop, true) : this.cache1.getRegion(this.aop, false);
            r1.registerContextClassLoader(cla);
            Region r2 = this.cache2.getRegion(this.aop, false) == null ? this.cache2.getRegion(this.aop, true) : this.cache2.getRegion(this.aop, false);
            r2.registerContextClassLoader(clb);
        }
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        this.replListener2.expectAny();
        this.beginTransaction();
        this.cache1.put(this.aop, (Object)"person", (Object)this.ben);
        this.commit();
        this.replListener2.waitForReplicationToOccur(1000L);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        Object ben2 = null;
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        ben2 = this.cache2.get(this.aop, (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertEquals((String)this.ben.toString(), (String)ben2.toString());
        Class<?> claz = clb.loadClass("org.jboss.cache.marshall.data.Address");
        Object add = claz.newInstance();
        Method setValue = claz.getMethod("setCity", String.class);
        setValue.invoke(add, "Sunnyvale");
        Class<?> clasz1 = clb.loadClass("org.jboss.cache.marshall.data.Person");
        setValue = clasz1.getMethod("setAddress", claz);
        setValue.invoke(ben2, add);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(clb);
        }
        this.replListener1.expectAny();
        this.cache2.put(this.aop, (Object)"person", ben2);
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        this.replListener1.waitForReplicationToOccur(100L);
        if (this.useMarshalledValues) {
            Thread.currentThread().setContextClassLoader(cla);
        }
        Object ben3 = this.cache1.get(this.aop, (Object)"person");
        if (this.useMarshalledValues) {
            this.resetContextClassLoader();
        }
        AssertJUnit.assertEquals((String)ben2.toString(), (String)ben3.toString());
    }

    public void testCustomFqn() throws Exception {
        FooClassLoader cl1 = new FooClassLoader(Thread.currentThread().getContextClassLoader());
        Region r1 = this.cache1.getRegion(this.aop, false) == null ? this.cache1.getRegion(this.aop, true) : this.cache1.getRegion(this.aop, false);
        r1.registerContextClassLoader((ClassLoader)cl1);
        FooClassLoader cl2 = new FooClassLoader(Thread.currentThread().getContextClassLoader());
        Region r2 = this.cache2.getRegion(this.aop, false) == null ? this.cache2.getRegion(this.aop, true) : this.cache2.getRegion(this.aop, false);
        r2.registerContextClassLoader((ClassLoader)cl2);
        Class clazz = cl1.loadFoo();
        Object custom1 = clazz.newInstance();
        clazz = cl2.loadFoo();
        Object custom2 = clazz.newInstance();
        Fqn base = Fqn.fromString((String)"/aop");
        Fqn fqn = Fqn.fromRelativeElements((Fqn)base, (Object[])new Object[]{custom1});
        this.replListener2.expectAny();
        this.cache1.put(fqn, (Object)"key", (Object)"value");
        this.replListener2.waitForReplicationToOccur(1000L);
        Fqn fqn2 = Fqn.fromRelativeElements((Fqn)base, (Object[])new Object[]{custom2});
        Object val = this.cache2.get(fqn2, (Object)"key");
        AssertJUnit.assertEquals((Object)"value", (Object)val);
    }

    private Transaction beginTransaction() throws SystemException, NotSupportedException {
        TransactionManager mgr = this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        mgr.begin();
        return mgr.getTransaction();
    }

    private void commit() throws SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.cache1.getConfiguration().getRuntimeConfig().getTransactionManager().commit();
    }

    protected Object getPersonFromClassloader(ClassLoader cl) throws Exception {
        Class<?> clazz = cl.loadClass("org.jboss.cache.marshall.data.Person");
        return clazz.newInstance();
    }

    private void log(String msg) {
        System.out.println("-- [" + Thread.currentThread() + "]: " + msg);
    }
}

