/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.ReversibleCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.Marshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class MethodIdPreservationTest {
    private Marshaller m;
    private ObjectOutputStream stream;
    private ByteArrayOutputStream byteStream;
    private ReversibleCommand command1;
    private List<ReversibleCommand> list = new ArrayList<ReversibleCommand>(2);
    private PrepareCommand prepareComand;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.byteStream = new ByteArrayOutputStream();
        this.stream = new ObjectOutputStream(this.byteStream);
        this.command1 = new PutDataMapCommand(null, Fqn.ROOT, null);
        this.list.clear();
        this.list.add(this.command1);
        this.list.add((ReversibleCommand)new PutDataMapCommand(null, Fqn.ROOT, null));
        this.prepareComand = new PrepareCommand(null, this.list, null, true);
        CacheMarshaller210 cm210 = new CacheMarshaller210();
        CommandsFactory factory = new CommandsFactory();
        cm210.injectCommandsFactory(factory);
        this.m = cm210;
    }

    public void testSingleMethodCall() throws Exception {
        this.m.objectToObjectStream((Object)this.command1, this.stream);
        this.stream.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.byteStream.toByteArray()));
        Object result = this.m.objectFromObjectStream(in);
        AssertJUnit.assertEquals(this.command1.getClass(), result.getClass());
    }

    public void testListOfMethodCalls() throws Exception {
        this.m.objectToObjectStream(this.list, this.stream);
        this.stream.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.byteStream.toByteArray()));
        Object result = this.m.objectFromObjectStream(in);
        AssertJUnit.assertEquals(this.list.getClass(), result.getClass());
        AssertJUnit.assertEquals((int)this.list.size(), (int)((List)result).size());
        assert (((List)result).get(0) instanceof PutDataMapCommand);
        assert (((List)result).get(1) instanceof PutDataMapCommand);
    }

    public void testMethodCallsInPrepare() throws Exception {
        this.m.objectToObjectStream((Object)this.prepareComand, this.stream);
        this.stream.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.byteStream.toByteArray()));
        Object result = this.m.objectFromObjectStream(in);
        AssertJUnit.assertEquals(this.prepareComand.getClass(), result.getClass());
        PrepareCommand prepareCallRes = (PrepareCommand)result;
        List listResult = prepareCallRes.getModifications();
        AssertJUnit.assertEquals((int)this.list.size(), (int)listResult.size());
        assert (listResult.get(0) instanceof PutDataMapCommand);
        assert (listResult.get(1) instanceof PutDataMapCommand);
    }
}

