/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.cache.transaction.DummyTransactionManagerLookup;
import org.jboss.cache.transaction.JBossStandaloneJTAManagerLookup;

public class TransactionSetup {
    private static final String JBOSS_JTA = "jboss-jta";
    private static Operations operations;

    private static void init() {
        String property = System.getProperty("org.jboss.cache.test.tm");
        if (JBOSS_JTA.equals(property)) {
            final String lookup = JBossStandaloneJTAManagerLookup.class.getName();
            final JBossStandaloneJTAManagerLookup instance = new JBossStandaloneJTAManagerLookup();
            operations = new Operations(){

                public UserTransaction getUserTransaction() {
                    try {
                        return instance.getUserTransaction();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void cleanup() {
                }

                public String getLookup() {
                    return lookup;
                }

                public TransactionManager getManager() {
                    try {
                        return instance.getTransactionManager();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        } else {
            final String lookup = DummyTransactionManagerLookup.class.getName();
            final DummyTransactionManagerLookup instance = new DummyTransactionManagerLookup();
            operations = new Operations(){

                public UserTransaction getUserTransaction() {
                    return instance.getUserTransaction();
                }

                public void cleanup() {
                    instance.cleanup();
                }

                public String getLookup() {
                    return lookup;
                }

                public TransactionManager getManager() {
                    try {
                        return instance.getTransactionManager();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
    }

    public static TransactionManager getManager() {
        return operations.getManager();
    }

    public static String getManagerLookup() {
        return operations.getLookup();
    }

    public static UserTransaction getUserTransaction() {
        return operations.getUserTransaction();
    }

    public static void cleanup() {
        operations.cleanup();
    }

    static {
        TransactionSetup.init();
    }

    private static interface Operations {
        public UserTransaction getUserTransaction();

        public String getLookup();

        public void cleanup();

        public TransactionManager getManager();
    }
}

