/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.ConnectionFactory;
import org.jboss.cache.loader.ManagedConnectionFactory;
import org.jboss.cache.lock.StripedLock;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AdjListJDBCCacheLoader
extends AbstractCacheLoader {
    protected ConnectionFactory cf;
    protected String driverName;
    private AdjListJDBCCacheLoaderConfig config;
    protected StripedLock lock = new StripedLock();
    protected static Log log = LogFactory.getLog(AdjListJDBCCacheLoader.class);
    protected static final Map<Object, Object> NULL_NODE_IN_ROW = new AbstractMap<Object, Object>(){

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            throw new UnsupportedOperationException();
        }
    };

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig base) {
        this.config = this.processConfig(base);
        if (this.config.getDatasourceName() == null) {
            try {
                log.debug((Object)"Initialising with a connection factory since data source is not provided.");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using connection factory " + this.config.getConnectionFactoryClass()));
                }
                this.cf = (ConnectionFactory)Util.loadClass(this.config.getConnectionFactoryClass()).newInstance();
            }
            catch (Exception e) {
                log.error((Object)"Connection factory class could not be loaded", (Throwable)e);
                throw new IllegalStateException("Connection factory class could not be loaded", e);
            }
        } else {
            this.cf = new ManagedConnectionFactory();
        }
        this.cf.setConfig(this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Object, Object> get(Fqn name) throws Exception {
        this.lock.acquireLock(name, false);
        try {
            HashMap<Object, Object> node = this.loadNode(name);
            HashMap<Object, Object> hashMap = node == NULL_NODE_IN_ROW ? new HashMap<Object, Object>(0) : node;
            return hashMap;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        HashSet<String> children = null;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing sql: " + this.config.getSelectChildNamesSql() + " (" + fqn + ")"));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getSelectChildNamesSql());
            ps.setString(1, fqn.toString());
            this.lock.acquireLock(fqn, false);
            rs = ps.executeQuery();
            if (rs.next()) {
                children = new HashSet<String>();
                do {
                    String child = rs.getString(1);
                    int slashInd = child.lastIndexOf(47);
                    String name = child.substring(slashInd + 1);
                    children.add(name);
                } while (rs.next());
            }
            this.safeClose(rs);
            this.safeClose(ps);
            this.cf.close(con);
            this.lock.releaseLock(fqn);
        }
        catch (SQLException e) {
            try {
                this.reportAndRethrowError("Failed to get children names for fqn " + fqn, e);
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(con);
                this.lock.releaseLock(fqn);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(ps);
                this.cf.close(con);
                this.lock.releaseLock(fqn);
                throw throwable;
            }
        }
        return children == null ? null : Collections.unmodifiableSet(children);
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.updateNode(name, null);
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        this.cf.prepare(tx);
        this.put(modifications);
        if (one_phase) {
            this.commit(tx);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        this.cf.commit(tx);
    }

    @Override
    public void rollback(Object tx) {
        this.cf.rollback(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        this.cf.start();
        Connection con = null;
        Statement st = null;
        try {
            con = this.cf.getConnection();
            this.driverName = this.getDriverName(con);
            if (this.config.getCreateTable() && !this.tableExists(this.config.getTable(), con)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("executing ddl: " + this.config.getCreateTableDDL()));
                }
                st = con.createStatement();
                st.executeUpdate(this.config.getCreateTableDDL());
            }
        }
        finally {
            this.safeClose(st);
            this.cf.close(con);
        }
        this.createDummyTableIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void createDummyTableIfNeeded() throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.cf.getConnection();
            ps = conn.prepareStatement(this.config.getDummyTableRemovalDDL());
            ps.execute();
            this.safeClose(ps);
            this.cf.close(conn);
        }
        catch (Exception exception) {
            this.safeClose(ps);
            this.cf.close(conn);
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(conn);
                throw throwable;
            }
        }
        try {
            conn = this.cf.getConnection();
            ps = conn.prepareStatement(this.config.getDummyTableCreationDDL());
            ps.execute();
            this.safeClose(ps);
            ps = conn.prepareStatement(this.config.getDummyTablePopulationSql());
            ps.execute();
        }
        finally {
            this.safeClose(ps);
            this.cf.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        block8: {
            try {
                if (!this.config.getDropTable()) break block8;
                Connection con = null;
                Statement st = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("executing ddl: " + this.config.getDropTableDDL()));
                    }
                    con = this.cf.getConnection();
                    st = con.createStatement();
                    st.executeUpdate(this.config.getDropTableDDL());
                    this.safeClose(st);
                    this.safeClose(st);
                    this.cf.close(con);
                }
                catch (SQLException e) {
                    try {
                        log.error((Object)("Failed to drop table: " + e.getMessage()), (Throwable)e);
                        this.safeClose(st);
                        this.cf.close(con);
                    }
                    catch (Throwable throwable) {
                        this.safeClose(st);
                        this.cf.close(con);
                        throw throwable;
                    }
                }
            }
            finally {
                this.cf.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Fqn name) throws Exception {
        this.lock.acquireLock(name, false);
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.cf.getConnection();
            ps = conn.prepareStatement(this.config.getExistsSql());
            ps.setString(1, name.toString());
            rs = ps.executeQuery();
            boolean bl = rs.next();
            this.lock.releaseLock(name);
            this.safeClose(rs);
            this.safeClose(ps);
            this.cf.close(conn);
            return bl;
        }
        catch (Throwable throwable) {
            this.lock.releaseLock(name);
            this.safeClose(rs);
            this.safeClose(ps);
            this.cf.close(conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        this.lock.acquireLock(name, true);
        try {
            Object removedValue = null;
            Map<Object, Object> node = this.loadNode(name);
            if (node != null && node != NULL_NODE_IN_ROW) {
                removedValue = node.remove(key);
                if (node.isEmpty()) {
                    this.updateNode(name, null);
                } else {
                    this.updateNode(name, node);
                }
            }
            Object object = removedValue;
            return object;
        }
        finally {
            this.lock.releaseLock(name);
        }
    }

    /*
     * Exception decompiling
     */
    protected Map<Object, Object> loadNode(Fqn name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void insertNode(Fqn name, Map node, boolean rowMayExist) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing sql: " + this.config.getInsertNodeSql() + " (" + name + ")"));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getInsertNodeSql());
            String fqnString = name.toString();
            ps.setString(1, fqnString);
            ps.setString(4, fqnString);
            if (node != null) {
                byte[] byteStream = this.marshall(node);
                ByteArrayInputStream bais = new ByteArrayInputStream(byteStream);
                ps.setBinaryStream(2, (InputStream)bais, byteStream.length);
            } else if (this.driverName != null && (this.driverName.contains("SQLSERVER") || this.driverName.contains("POSTGRESQL"))) {
                ps.setNull(2, -4);
            } else {
                ps.setNull(2, 2004);
            }
            if (name.size() == 0) {
                ps.setNull(3, 12);
            } else {
                ps.setString(3, name.getAncestor(name.size() - 1).toString());
            }
            int rows = ps.executeUpdate();
            if (!rowMayExist && rows != 1) {
                throw new IllegalStateException("Expected one insert row but got " + rows);
            }
        }
        catch (RuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    log.error((Object)("Failed to insert node :" + e2.getMessage()));
                    throw new IllegalStateException("Failed to insert node: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
        this.safeClose(ps);
        this.cf.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNode(Fqn name, Map<Object, Object> node) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("executing sql: " + this.config.getUpdateNodeSql()));
            }
            con = this.cf.getConnection();
            ps = con.prepareStatement(this.config.getUpdateNodeSql());
            if (node == null) {
                node = new HashMap<Object, Object>(0);
            }
            byte[] byteStream = this.marshall(node);
            ByteArrayInputStream bais = new ByteArrayInputStream(byteStream);
            ps.setBinaryStream(1, (InputStream)bais, byteStream.length);
            ps.setString(2, name.toString());
            ps.executeUpdate();
            this.safeClose(ps);
            this.cf.close(con);
        }
        catch (Exception e) {
            try {
                this.reportAndRethrowError("Failed to update node for fqn " + name, e);
                this.safeClose(ps);
                this.cf.close(con);
            }
            catch (Throwable throwable) {
                this.safeClose(ps);
                this.cf.close(con);
                throw throwable;
            }
        }
    }

    protected String getDriverName(Connection con) {
        if (con == null) {
            return null;
        }
        try {
            DatabaseMetaData dmd = con.getMetaData();
            return AdjListJDBCCacheLoader.toUpperCase(dmd.getDriverName());
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error while getting the driver name", e);
        }
    }

    static String getRequiredProperty(Properties props, String name) {
        String value = props.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Missing required property: " + name);
        }
        return value;
    }

    protected boolean tableExists(String tableName, Connection con) {
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = con.getMetaData();
            String catalog = con.getCatalog();
            String schema = null;
            String quote = dmd.getIdentifierQuoteString();
            if (tableName.startsWith(quote)) {
                if (!tableName.endsWith(quote)) {
                    throw new IllegalStateException("Mismatched quote in table name: " + tableName);
                }
                int quoteLength = quote.length();
                tableName = tableName.substring(quoteLength, tableName.length() - quoteLength);
                if (dmd.storesLowerCaseQuotedIdentifiers()) {
                    tableName = AdjListJDBCCacheLoader.toLowerCase(tableName);
                } else if (dmd.storesUpperCaseQuotedIdentifiers()) {
                    tableName = AdjListJDBCCacheLoader.toUpperCase(tableName);
                }
            } else if (dmd.storesLowerCaseIdentifiers()) {
                tableName = AdjListJDBCCacheLoader.toLowerCase(tableName);
            } else if (dmd.storesUpperCaseIdentifiers()) {
                tableName = AdjListJDBCCacheLoader.toUpperCase(tableName);
            }
            int dotIndex = tableName.indexOf(46);
            if (dotIndex != -1) {
                schema = tableName.substring(0, dotIndex);
                tableName = tableName.substring(dotIndex + 1);
            }
            rs = dmd.getTables(catalog, schema, tableName, null);
            boolean bl = rs.next();
            this.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Error while checking if table aleady exists " + tableName, e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                throw throwable;
            }
        }
    }

    protected abstract AdjListJDBCCacheLoaderConfig processConfig(CacheLoaderConfig.IndividualCacheLoaderConfig var1);

    protected void reportAndRethrowError(String message, Exception cause) throws IllegalStateException {
        log.error((Object)message, (Throwable)cause);
        throw new IllegalStateException(message, cause);
    }

    protected void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)("Failed to close input stream: " + e.getMessage()));
            }
        }
    }

    protected void safeClose(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close statement: " + e.getMessage()));
            }
        }
    }

    protected void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.warn((Object)("Failed to close result set: " + e.getMessage()));
            }
        }
    }

    protected Object unmarshall(InputStream from) throws Exception {
        return this.getMarshaller().objectFromStream(from);
    }

    protected byte[] marshall(Object obj) throws Exception {
        return this.getMarshaller().objectToByteBuffer(obj);
    }

    private static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    private static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }
}

