/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.loader.AdjListJDBCCacheLoaderConfig;
import org.jboss.cache.loader.NonManagedConnectionFactory;

public class C3p0ConnectionFactory
extends NonManagedConnectionFactory {
    private static final Log log = LogFactory.getLog(C3p0ConnectionFactory.class);
    private static final boolean trace = log.isTraceEnabled();
    private DataSource ds;

    public void setConfig(AdjListJDBCCacheLoaderConfig config) {
        super.setConfig(config);
        Properties properties = config.getProperties();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            if (!property.startsWith("c3p0.")) continue;
            String xmlPropertyValue = properties.getProperty(property);
            String sysPropertyValue = System.getProperty(property);
            if (System.getProperty(property) == null) {
                System.setProperty(property, xmlPropertyValue);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("c3p0 property defined in XML: " + property + "=" + xmlPropertyValue));
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(property + "=" + sysPropertyValue + " defined as system property. It will override the value defined in XML which was: " + xmlPropertyValue));
        }
    }

    public void start() throws Exception {
        super.start();
        DataSource unpooled = DataSources.unpooledDataSource((String)this.getUrl(), (String)this.getUsr(), (String)this.getPwd());
        this.ds = DataSources.pooledDataSource((DataSource)unpooled);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Pooled datasource(url=" + this.getUrl() + ",usr=" + this.getUsr() + ",pwd=" + this.getPwd() + ") started."));
        }
    }

    public Connection checkoutConnection() throws SQLException {
        Connection connection = this.ds.getConnection();
        if (trace) {
            log.trace((Object)("Connection checked out: " + connection));
        }
        return connection;
    }

    public void stop() {
        try {
            DataSources.destroy((DataSource)this.ds);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Pooled datasource destroyed.");
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("Could not destroy C3P0 connection pool: " + this.ds), (Throwable)sqle);
        }
    }

    protected DataSource getDataSource() {
        return this.ds;
    }
}

