/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.io.ByteBuffer;
import org.jboss.cache.io.ExposedByteArrayOutputStream;
import org.jboss.cache.marshall.AbstractMarshaller;
import org.jboss.cache.marshall.CacheMarshaller200;
import org.jboss.cache.marshall.CacheMarshaller210;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.marshall.RegionalizedMethodCall;
import org.jboss.cache.util.Util;
import org.jboss.util.stream.MarshalledValueInputStream;

public class VersionAwareMarshaller
extends AbstractMarshaller {
    private static final Log log = LogFactory.getLog(VersionAwareMarshaller.class);
    private static final int VERSION_200 = 20;
    private static final int VERSION_210 = 21;
    private static final int VERSION_220 = 22;
    private static final int CUSTOM_MARSHALLER = 999;
    private ComponentRegistry componentRegistry;
    Marshaller defaultMarshaller;
    final Map<Integer, Marshaller> marshallers = new HashMap<Integer, Marshaller>();
    private int versionInt;

    @Inject
    void injectComponents(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Start
    public void initReplicationVersions() {
        String marshallerClass;
        String replVersionString = this.configuration.getReplVersionString();
        this.defaultMarshaller = this.configuration.getMarshaller();
        if (this.defaultMarshaller == null && (marshallerClass = this.configuration.getMarshallerClass()) != null) {
            if (this.trace) {
                log.trace((Object)("Cache marshaller implementation specified as " + marshallerClass + ".  Overriding any version strings passed in. "));
            }
            try {
                this.defaultMarshaller = (Marshaller)Util.loadClass(marshallerClass).newInstance();
            }
            catch (Exception e) {
                log.warn((Object)("Unable to instantiate marshaller of class " + marshallerClass), (Throwable)e);
                log.warn((Object)("Falling back to using the default marshaller for version string " + replVersionString));
            }
        }
        if (this.defaultMarshaller == null) {
            this.versionInt = this.toMinorVersionInt(replVersionString);
            this.defaultMarshaller = this.getMarshaller(this.versionInt);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using the marshaller passed in - " + this.defaultMarshaller));
            }
            this.versionInt = this.getCustomMarshallerVersionInt();
            this.marshallers.put(this.versionInt, this.defaultMarshaller);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started with version " + replVersionString + " and versionInt " + this.versionInt));
            log.debug((Object)("Using default marshaller class " + this.defaultMarshaller.getClass()));
        }
    }

    protected int getCustomMarshallerVersionInt() {
        if (this.defaultMarshaller.getClass().equals(CacheMarshaller210.class)) {
            return 21;
        }
        if (this.defaultMarshaller.getClass().equals(CacheMarshaller200.class)) {
            return 20;
        }
        return 999;
    }

    private int toMinorVersionInt(String version) {
        try {
            StringTokenizer strtok = new StringTokenizer(version, ".");
            String[] versionComponents = new String[]{null, null, null, null};
            int i = 0;
            while (strtok.hasMoreTokens()) {
                versionComponents[i++] = strtok.nextToken();
            }
            int major = Integer.parseInt(versionComponents[0]);
            int minor = Integer.parseInt(versionComponents[1]);
            return major > 1 || minor > 3 ? 10 * major + minor : 1;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported replication version string " + version);
        }
    }

    public ByteBuffer objectToBuffer(Object obj) throws Exception {
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(128);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeShort(this.versionInt);
        if (this.trace) {
            log.trace((Object)("Wrote version " + this.versionInt));
        }
        this.defaultMarshaller.objectToObjectStream(obj, out);
        out.close();
        return new ByteBuffer(baos.getRawBuffer(), 0, baos.size());
    }

    public Object objectFromByteBuffer(byte[] bytes, int offset, int len) throws Exception {
        short versionId;
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)new ByteArrayInputStream(bytes, offset, len));
        try {
            versionId = in.readShort();
            if (this.trace) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.objectFromObjectStream((ObjectInputStream)in);
    }

    public RegionalizedMethodCall regionalizedMethodCallFromByteBuffer(byte[] buf) throws Exception {
        short versionId;
        MarshalledValueInputStream in = new MarshalledValueInputStream((InputStream)new ByteArrayInputStream(buf));
        try {
            versionId = in.readShort();
            if (this.trace) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.regionalizedMethodCallFromObjectStream((ObjectInputStream)in);
    }

    public Object objectFromStream(InputStream is) throws Exception {
        short versionId;
        if (is instanceof ByteArrayInputStream) {
            int avbl = is.available();
            byte[] bytes = new byte[avbl];
            is.read(bytes, 0, avbl);
            return this.objectFromByteBuffer(bytes);
        }
        MarshalledValueInputStream in = new MarshalledValueInputStream(is);
        try {
            versionId = in.readShort();
            if (this.trace) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.objectFromObjectStream((ObjectInputStream)in);
    }

    public void objectToObjectStream(Object obj, ObjectOutputStream out, Fqn region) throws Exception {
        out.writeShort(this.versionInt);
        if (this.trace) {
            log.trace((Object)("Wrote version " + this.versionInt));
        }
        this.defaultMarshaller.objectToObjectStream(obj, out, region);
    }

    Marshaller getMarshaller(int versionId) {
        Marshaller marshaller;
        boolean knownVersion = false;
        switch (versionId) {
            case 20: {
                marshaller = this.marshallers.get(20);
                if (marshaller != null) break;
                CacheMarshaller200 am = new CacheMarshaller200();
                marshaller = am;
                this.componentRegistry.wireDependencies(am);
                am.init();
                this.marshallers.put(20, marshaller);
                break;
            }
            case 21: 
            case 22: {
                knownVersion = true;
            }
            default: {
                if (!knownVersion && log.isWarnEnabled()) {
                    log.warn((Object)"Unknown replication version String.  Falling back to the default marshaller installed.");
                }
                if ((marshaller = this.marshallers.get(21)) != null) break;
                CacheMarshaller210 am = new CacheMarshaller210();
                marshaller = am;
                this.componentRegistry.wireDependencies(am);
                am.init();
                this.marshallers.put(21, marshaller);
            }
        }
        return marshaller;
    }

    public void objectToObjectStream(Object obj, ObjectOutputStream out) throws Exception {
        out.writeShort(this.versionInt);
        if (this.trace) {
            log.trace((Object)("Wrote version " + this.versionInt));
        }
        this.defaultMarshaller.objectToObjectStream(obj, out);
    }

    public Object objectFromObjectStream(ObjectInputStream in) throws Exception {
        short versionId;
        try {
            versionId = in.readShort();
            if (this.trace) {
                log.trace((Object)("Read version " + versionId));
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read version id from first two bytes of stream, barfing.");
            throw e;
        }
        Marshaller marshaller = this.getMarshaller(versionId);
        return marshaller.objectFromObjectStream(in);
    }
}

