/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.ReversibleCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.lock.NodeLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class TransactionEntry {
    private static final Log log = LogFactory.getLog(TransactionEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    private Transaction ltx = null;
    private Option option;
    private OrderedSynchronizationHandler orderedSynchronizationHandler;
    private boolean forceAsyncReplication = false;
    private boolean forceSyncReplication = false;
    private List<ReversibleCommand> modificationList;
    private List<ReversibleCommand> localModifications;
    private final LinkedHashSet<NodeLock> locks = new LinkedHashSet();
    private List<Fqn> dummyNodesCreatedByCacheLoader;
    private final List<Fqn> removedNodes = new LinkedList<Fqn>();

    public TransactionEntry(Transaction tx) throws SystemException, RollbackException {
        this.ltx = tx;
        this.orderedSynchronizationHandler = new OrderedSynchronizationHandler(tx);
    }

    public void addModification(ReversibleCommand command) {
        if (command == null) {
            return;
        }
        if (this.modificationList == null) {
            this.modificationList = new LinkedList<ReversibleCommand>();
        }
        this.modificationList.add(command);
    }

    public List<ReversibleCommand> getModifications() {
        if (this.modificationList == null) {
            return Collections.emptyList();
        }
        return this.modificationList;
    }

    public void addLocalModification(ReversibleCommand command) {
        if (command == null) {
            return;
        }
        if (this.localModifications == null) {
            this.localModifications = new LinkedList<ReversibleCommand>();
        }
        this.localModifications.add(command);
    }

    public List<ReversibleCommand> getLocalModifications() {
        if (this.localModifications == null) {
            return Collections.emptyList();
        }
        return this.localModifications;
    }

    public void addRemovedNode(Fqn fqn) {
        this.removedNodes.add(fqn);
    }

    public List<Fqn> getRemovedNodes() {
        return new ArrayList<Fqn>(this.removedNodes);
    }

    public void setTransaction(Transaction tx) {
        this.ltx = tx;
    }

    public Transaction getTransaction() {
        return this.ltx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(NodeLock l) {
        if (l != null) {
            LinkedHashSet<NodeLock> linkedHashSet = this.locks;
            synchronized (linkedHashSet) {
                this.locks.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocks(Collection<NodeLock> newLocks) {
        if (newLocks != null) {
            LinkedHashSet<NodeLock> linkedHashSet = this.locks;
            synchronized (linkedHashSet) {
                this.locks.addAll(newLocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeLock> getLocks() {
        LinkedHashSet<NodeLock> linkedHashSet = this.locks;
        synchronized (linkedHashSet) {
            return new ArrayList<NodeLock>(this.locks);
        }
    }

    public boolean isForceAsyncReplication() {
        return this.forceAsyncReplication;
    }

    public void setForceAsyncReplication(boolean forceAsyncReplication) {
        this.forceAsyncReplication = forceAsyncReplication;
        if (forceAsyncReplication) {
            this.forceSyncReplication = false;
        }
    }

    public boolean isForceSyncReplication() {
        return this.forceSyncReplication;
    }

    public void setForceSyncReplication(boolean forceSyncReplication) {
        this.forceSyncReplication = forceSyncReplication;
        if (forceSyncReplication) {
            this.forceAsyncReplication = false;
        }
    }

    public void undoOperations() {
        if (this.modificationList == null) {
            if (trace) {
                log.trace((Object)"Modification list is null, no modifications in this transaction!");
            }
            return;
        }
        if (trace) {
            log.trace((Object)("undoOperations " + this.modificationList));
        }
        ArrayList<ReversibleCommand> copy = new ArrayList<ReversibleCommand>(this.modificationList);
        ListIterator<ReversibleCommand> i = copy.listIterator(copy.size());
        while (i.hasPrevious()) {
            ReversibleCommand undoOp;
            ReversibleCommand txCommand = undoOp = i.previous();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling rollback() on command " + undoOp));
            }
            txCommand.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransactionEntry\nmodificationList: ").append(this.modificationList);
        LinkedHashSet<NodeLock> linkedHashSet = this.locks;
        synchronized (linkedHashSet) {
            sb.append("\nlocks: ").append(this.locks);
        }
        return sb.toString();
    }

    public void loadUninitialisedNode(Fqn fqn) {
        if (this.dummyNodesCreatedByCacheLoader == null) {
            this.dummyNodesCreatedByCacheLoader = new LinkedList<Fqn>();
        }
        this.dummyNodesCreatedByCacheLoader.add(fqn);
    }

    public List<Fqn> getDummyNodesCreatedByCacheLoader() {
        return this.dummyNodesCreatedByCacheLoader;
    }

    public void setOption(Option o) {
        this.option = o;
    }

    public Option getOption() {
        return this.option;
    }

    public OrderedSynchronizationHandler getOrderedSynchronizationHandler() {
        return this.orderedSynchronizationHandler;
    }

    public void setOrderedSynchronizationHandler(OrderedSynchronizationHandler orderedSynchronizationHandler) {
        this.orderedSynchronizationHandler = orderedSynchronizationHandler;
    }

    public boolean hasModifications() {
        return this.modificationList != null && !this.modificationList.isEmpty();
    }

    public boolean hasLocalModifications() {
        return this.localModifications != null && !this.localModifications.isEmpty();
    }

    public void reset() {
        this.orderedSynchronizationHandler = null;
        if (this.modificationList != null) {
            this.modificationList = null;
        }
        if (this.localModifications != null) {
            this.localModifications = null;
        }
        this.option = null;
        this.locks.clear();
        if (this.dummyNodesCreatedByCacheLoader != null) {
            this.dummyNodesCreatedByCacheLoader.clear();
        }
        this.removedNodes.clear();
    }
}

