/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.jboss.cache.util.SimpleImmutableEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class MapCopy<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -958813082188242956L;
    private final List<Map.Entry<K, V>> data;
    private transient Set<Map.Entry<K, V>> entrySet;

    public MapCopy(Map<K, V> m) {
        this.data = new ArrayList<Map.Entry<K, V>>(m.size());
        for (Map.Entry<K, V> me : m.entrySet()) {
            if (me == null) {
                throw new NullPointerException();
            }
            this.data.add(new SimpleImmutableEntry<K, V>(me));
        }
        this.init();
    }

    public MapCopy() {
        this(new HashMap(0));
    }

    public static <L, W> Map<L, W> copy(Map<L, W> m) {
        return new MapCopy<L, W>(m);
    }

    private void init() {
        this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return MapCopy.this.data.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private int index;

        private EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < MapCopy.this.data.size();
        }

        @Override
        public Map.Entry<K, V> next() {
            return (Map.Entry)MapCopy.this.data.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

