/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.pojo;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertSame;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.pojo.annotation.Replicable;
import org.jboss.cache.pojo.test.EnumPlanet;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Basic PojoCache test case for Enum.
 *
 * @author Ben Wang
 */

@Test(groups = {"functional"})
public class EnumTest 
{
   Log log = LogFactory.getLog(EnumTest.class);
   PojoCache cache_, cache1_;

   @Replicable
   public static class EnumContainer
   {
	   private EnumPlanet planet = EnumPlanet.EARTH;

	   public void setPlanet(EnumPlanet planet)
	   {
	      this.planet = planet;
	   }

      public EnumPlanet getPlanet()
      {
         return planet;
      }

      public boolean equals(Object o)
      {
         if (! (o instanceof EnumContainer))
            return false;

         EnumContainer container = (EnumContainer)o;
         return planet.equals(container.planet);
      }
   }


   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log.info("setUp() ....");
      boolean toStart = true;
      cache_ = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
      cache1_ = PojoCacheFactory.createCache(UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.REPL_SYNC), toStart);
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache_.stop();
      cache1_.stop();
   }

   public void testSolo() throws Exception
   {
      log.info("testSolo() ....");
      cache_.attach("/enum", EnumPlanet.EARTH);
      EnumPlanet ep = (EnumPlanet) cache1_.find("/enum");

      // Enum's use read resolve
      assertSame(ep, EnumPlanet.EARTH);
   }

   public void testField() throws Exception
   {
      log.info("testField() ....");
      cache_.attach("/enum", EnumPlanet.EARTH);
      EnumPlanet ep = (EnumPlanet) cache1_.find("/enum");

      assertSame(ep, EnumPlanet.EARTH);

      EnumContainer container = new EnumContainer();
      cache_.attach("/enumcontainer", container);

      EnumContainer container2 = (EnumContainer) cache1_.find("/enumcontainer");
      assertEquals(container, container2);

      container.setPlanet(EnumPlanet.JUPITER);
      assertEquals(container, container2);
   }



}
