/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.pojo;

import static org.testng.AssertJUnit.assertEquals;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.Configuration.CacheMode;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Tests the usage and behavior of PojoCacheThreadContext
 *
 * @author Jason T. Greene
 */
@Test(groups = {"functional"})
public class PojoCacheThreadContextTest 
{
   Log log = LogFactory.getLog(ReplicatedTest.class);
   volatile PojoCache cache, cache1;

   @BeforeMethod(alwaysRun = true)
   protected void setUp() throws Exception
   {
      log.info("setUp() ....");
      boolean toStart = false;
      Configuration cfg1 = UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.LOCAL);
      cache = PojoCacheFactory.createCache(cfg1, toStart);
      cache.start();
      Configuration cfg2 = UnitTestCacheConfigurationFactory.createConfiguration(CacheMode.LOCAL);
      cache1 = PojoCacheFactory.createCache(cfg2, toStart);
      cache1.start();
   }

   @AfterMethod(alwaysRun = true)
   protected void tearDown() throws Exception
   {
      cache.stop();
      cache1.stop();
   }

   public void testDefault()
   {
      assertEquals(cache.getThreadContext().isGravitationEnabled(), false);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), false);
   }
   
   public void testClear()
   {
      cache1.getThreadContext().setGravitationEnabled(true);
      cache.getThreadContext().setGravitationEnabled(true);
      
      assertEquals(cache.getThreadContext().isGravitationEnabled(), true);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), true);
      
      cache1.getThreadContext().clear();
      
      assertEquals(cache.getThreadContext().isGravitationEnabled(), true);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), false);
   }
   
   private class TestThread extends Thread
   {
      public volatile Throwable t;

      @Override
      public void run()
      {
         try
         {
            cache1.getThreadContext().setGravitationEnabled(true);
            assertEquals(cache.getThreadContext().isGravitationEnabled(), false);
            assertEquals(cache1.getThreadContext().isGravitationEnabled(), true);
         
            cache.getThreadContext().setGravitationEnabled(true);
            assertEquals(cache.getThreadContext().isGravitationEnabled(), true);
            assertEquals(cache1.getThreadContext().isGravitationEnabled(), true);
         }
         catch (Throwable t)
         {
            this.t = t;
         }
      }
   };

   public void testThreadIsolation() throws Throwable
   {
      assertEquals(cache.getThreadContext().isGravitationEnabled(), false);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), false);
      
      
      TestThread t1 = new TestThread();
      t1.start();
      t1.join();
      if (t1.t != null)
         throw t1.t;
      
      assertEquals(cache.getThreadContext().isGravitationEnabled(), false);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), false);

      cache1.getThreadContext().setGravitationEnabled(true);
      assertEquals(cache.getThreadContext().isGravitationEnabled(), false);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), true);
      t1 = new TestThread();
      t1.start();
      t1.join();
      if (t1.t != null)
         throw t1.t;
      
      assertEquals(cache.getThreadContext().isGravitationEnabled(), false);
      assertEquals(cache1.getThreadContext().isGravitationEnabled(), true);
   }
}
