/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.cache.pojo.test;

/**
 * Test class for PojoCache Enum.
 *
 * @version $Revision: 6555 $
 */
public enum EnumPlanet
{
   MERCURY(3.303e+23, 2.4397e6),
   VENUS(4.869e+24, 6.0518e6),
   EARTH(5.976e+24, 6.37814e6),
   MARS(6.421e+23, 3.3972e6),
   JUPITER(1.9e+27, 7.1492e7),
   SATURN(5.688e+26, 6.0268e7),
   URANUS(8.686e+25, 2.5559e7),
   NEPTUNE(1.024e+26, 2.4746e7);

   private final double mass;   // in kilograms
   private final double radius; // in meters

   private EnumPlanet(double mass, double radius)
   {
      this.mass = mass;
      this.radius = radius;
   }

   public double mass()
   {
      return mass;
   }

   public double radius()
   {
      return radius;
   }

   // universal gravitational constant  (m3 kg-1 s-2)
   public static final double G = 6.67300E-11;

   public double surfaceGravity()
   {
      return G * mass / (radius * radius);
   }

   public double surfaceWeight(double otherMass)
   {
      return otherMass * surfaceGravity();
   }
}
