/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.pojo.test;

/**
 * A non-serializable object
 */
public class NonSerializableObject {

   private String id;

   public String getId() {
      return id;
   }

   public void setId(String id) {
      this.id = id;
   }

  public NonSerializableObject()  {
  }

  public NonSerializableObject(String aId)  {
    id = aId;
  }


  public String toString()  {
    return id;
  }

  public boolean equals(Object aObject)  {
    boolean result = false;

    if ((aObject != null) &&
         (aObject.getClass().getName().equals( this.getClass().getName()))) {
      if (id.equals(((NonSerializableObject)aObject).id)) {
        result = true;
      } // if
    } // if

    return result;
  } // equals

  public int hashCode()  {
    return id.hashCode();
  } // hashCode
} // class IdObject
