package org.jboss.cache.pojo.test.propagation.impl;

import org.jboss.cache.pojo.test.propagation.PropagationRule;
import org.jboss.cache.pojo.test.propagation.StateItem;

public class StateItemImpl implements StateItem
{
   private long itemId_;
   private long state_;

   public StateItemImpl()
   {
   }

   public StateItemImpl(long itemId)
   {
      this.itemId_ = itemId;
      this.state_ = PropagationRule.STATE_CLEAR;
   }

   public long getState()
   {
      return this.state_;
   }

   public boolean setState(long state)
   {
      if (this.state_ != state)
      {
         state_ = state;
         return STATE_CHANGED;
      } else
      {
         return STATE_NOT_CHANGED;
      }
   }

   public long getItemId()
   {
      return this.itemId_;
   }

   public String toString()
   {
      return "Id: " + itemId_ + " state: " + state_ + "\n";
   }
}
