/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.mvcc.repeatable_read;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.api.mvcc.LockTestBase;
import org.testng.annotations.Test;

@Test(groups={"functional", "mvcc"})
public class RepeatableReadLockTest
extends LockTestBase {
    public RepeatableReadLockTest() {
        this.repeatableRead = true;
    }

    public void testRepeatableReadWithRemove() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put(this.AB, (Object)"k", (Object)"v");
        tm.begin();
        assert (cache.getNode(this.AB) != null);
        Transaction reader = tm.suspend();
        tm.begin();
        assert (cache.removeNode(this.AB));
        assert (cache.getNode(this.AB) == null);
        tm.commit();
        assert (cache.getNode(this.AB) == null);
        tm.resume(reader);
        assert (cache.getNode(this.AB) != null);
        assert ("v".equals(cache.get(this.AB, (Object)"k")));
        tm.commit();
        assert (cache.getNode(this.AB) == null);
        this.assertNoLocks();
    }

    public void testRepeatableReadWithEvict() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        cache.put(this.AB, (Object)"k", (Object)"v");
        tm.begin();
        assert (cache.getNode(this.AB) != null);
        Transaction reader = tm.suspend();
        tm.begin();
        cache.evict(this.AB);
        assert (cache.getNode(this.AB) == null);
        tm.commit();
        assert (cache.getNode(this.AB) == null);
        tm.resume(reader);
        assert (cache.getNode(this.AB) != null);
        assert ("v".equals(cache.get(this.AB, (Object)"k")));
        tm.commit();
        assert (cache.getNode(this.AB) == null);
        this.assertNoLocks();
    }

    public void testRepeatableReadWithNull() throws Exception {
        LockTestBase.LockTestBaseTL tl = (LockTestBase.LockTestBaseTL)this.threadLocal.get();
        Cache<String, String> cache = tl.cache;
        TransactionManager tm = tl.tm;
        assert (cache.getNode(this.AB) == null);
        tm.begin();
        assert (cache.getNode(this.AB) == null);
        Transaction reader = tm.suspend();
        tm.begin();
        cache.put(this.AB, (Object)"k", (Object)"v");
        assert (cache.getNode(this.AB) != null);
        assert ("v".equals(cache.get(this.AB, (Object)"k")));
        tm.commit();
        assert (cache.getNode(this.AB) != null);
        assert ("v".equals(cache.get(this.AB, (Object)"k")));
        tm.resume(reader);
        assert (cache.getNode(this.AB) == null);
        assert (cache.get(this.AB, (Object)"k") == null);
        tm.commit();
        assert (cache.getNode(this.AB) != null);
        assert ("v".equals(cache.get(this.AB, (Object)"k")));
        this.assertNoLocks();
    }
}

