/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.pfer;

import javax.transaction.Transaction;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.api.pfer.PutForExternalReadTestBase;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.lock.NodeLock;
import org.testng.AssertJUnit;

public abstract class PFERPessimisticTestBase
extends PutForExternalReadTestBase {
    protected PFERPessimisticTestBase() {
        this.nodeLockingScheme = Configuration.NodeLockingScheme.PESSIMISTIC;
    }

    protected void assertLocked(Fqn fqn, CacheSPI cache, boolean writeLocked) {
        NodeLock lock = cache.peek(fqn, true, true).getLock();
        AssertJUnit.assertTrue((String)("node " + fqn + " is not locked"), (boolean)lock.isLocked());
        if (writeLocked) {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not write-locked" + (lock.isReadLocked() ? " but is read-locked instead!" : "!")), (boolean)lock.isWriteLocked());
        } else {
            AssertJUnit.assertTrue((String)("node " + fqn + " is not read-locked" + (lock.isWriteLocked() ? " but is write-locked instead!" : "!")), (boolean)lock.isReadLocked());
        }
    }

    public void testNoOpWhenLockedAnd0msTimeout() throws Exception {
        PutForExternalReadTestBase.PutForExternalReadTestBaseTL threadCfg = (PutForExternalReadTestBase.PutForExternalReadTestBaseTL)this.threadLocal.get();
        threadCfg.cache1.put(this.parentFqn, (Object)"k", (Object)"v");
        threadCfg.tm1.begin();
        threadCfg.cache1.put(this.parentFqn, (Object)"k", (Object)"v2");
        Transaction t = threadCfg.tm1.suspend();
        this.assertLocked(this.parentFqn, threadCfg.cache1, true);
        long startTime = System.currentTimeMillis();
        threadCfg.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        long waited = System.currentTimeMillis() - startTime;
        AssertJUnit.assertTrue((String)("Should not wait " + waited + " millis for lock timeout, should attempt to acquire lock with 0ms!"), (waited < threadCfg.cache1.getConfiguration().getLockAcquisitionTimeout() ? 1 : 0) != 0);
        threadCfg.tm1.resume(t);
        threadCfg.tm1.commit();
        this.asyncWait();
        AssertJUnit.assertEquals((String)"Parent node write should have succeeded", (String)"v2", (String)((String)threadCfg.cache1.get(this.parentFqn, (Object)"k")));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"Parent node write should have invalidated", (Object)threadCfg.cache2.get(this.parentFqn, (Object)"k"));
        } else {
            AssertJUnit.assertEquals((String)"Parent node write should have replicated", (String)"v2", (String)((String)threadCfg.cache2.get(this.parentFqn, (Object)"k")));
        }
        AssertJUnit.assertNull((String)"PFER should have been a no-op", (Object)threadCfg.cache1.get(this.fqn, (Object)"k"));
        AssertJUnit.assertNull((String)"PFER should have been a no-op", (Object)threadCfg.cache2.get(this.fqn, (Object)"k"));
    }
}

