/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.api.pfer;

import java.util.List;
import java.util.Vector;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.easymock.EasyMock;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.RPCManager;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionContext;
import org.jboss.cache.util.TestingUtil;
import org.jboss.cache.util.internals.ReplicationListener;
import org.jgroups.Address;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional", "jgroups", "transaction"})
public abstract class PutForExternalReadTestBase {
    protected Configuration.CacheMode cacheMode;
    protected Configuration.NodeLockingScheme nodeLockingScheme;
    protected final Fqn fqn = Fqn.fromString((String)"/one/two");
    protected final Fqn parentFqn = this.fqn.getParent();
    protected final String key = "k";
    protected final String value = "v";
    protected final String value2 = "v2";
    ThreadLocal<PutForExternalReadTestBaseTL> threadLocal = new ThreadLocal();

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        PutForExternalReadTestBaseTL tl = new PutForExternalReadTestBaseTL();
        this.threadLocal.set(tl);
        UnitTestCacheFactory cf = new UnitTestCacheFactory();
        tl.cache1 = (CacheSPI)cf.createCache(UnitTestCacheConfigurationFactory.createConfiguration(this.cacheMode), false);
        tl.cache1.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        tl.cache1.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        tl.cache1.start();
        tl.tm1 = tl.cache1.getConfiguration().getRuntimeConfig().getTransactionManager();
        tl.cache2 = (CacheSPI)cf.createCache(UnitTestCacheConfigurationFactory.createConfiguration(this.cacheMode), false);
        tl.cache2.getConfiguration().setTransactionManagerLookupClass("org.jboss.cache.transaction.DummyTransactionManagerLookup");
        tl.cache2.getConfiguration().setNodeLockingScheme(this.nodeLockingScheme);
        tl.cache2.start();
        tl.tm2 = tl.cache2.getConfiguration().getRuntimeConfig().getTransactionManager();
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{tl.cache1, tl.cache2});
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        if (tl != null) {
            TestingUtil.killCaches(new Cache[]{tl.cache1, tl.cache2});
            this.threadLocal.set(null);
        }
    }

    public void testNoOpWhenNodePresent() {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        this.asyncWait();
        AssertJUnit.assertEquals((String)"PFER should have succeeded", (String)"v", (String)((String)tl.cache1.get(this.fqn, (Object)"k")));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"PFER should not have effected cache2", (Object)tl.cache2.get(this.fqn, (Object)"k"));
        } else {
            AssertJUnit.assertEquals((String)"PFER should have replicated", (String)"v", (String)((String)tl.cache2.get(this.fqn, (Object)"k")));
        }
        tl.cache1.removeNode(this.fqn);
        this.asyncWait();
        AssertJUnit.assertFalse((String)"Should have reset", (boolean)tl.cache1.getRoot().hasChild(this.fqn));
        AssertJUnit.assertFalse((String)"Should have reset", (boolean)tl.cache2.getRoot().hasChild(this.fqn));
        tl.cache1.put(this.fqn, (Object)"k", (Object)"v");
        this.asyncWait();
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v2");
        AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)"v", (String)((String)tl.cache1.get(this.fqn, (Object)"k")));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"PFER should have been a no-op", (Object)tl.cache2.get(this.fqn, (Object)"k"));
        } else {
            AssertJUnit.assertEquals((String)"PFER should have been a no-op", (String)"v", (String)((String)tl.cache2.get(this.fqn, (Object)"k")));
        }
    }

    private Vector<Address> anyAddresses() {
        EasyMock.anyObject();
        return null;
    }

    public void testAsyncForce() throws Exception {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        RPCManager rpcManager = (RPCManager)EasyMock.createNiceMock(RPCManager.class);
        RPCManager originalRpcManager = tl.cache1.getConfiguration().getRuntimeConfig().getRPCManager();
        List memberList = originalRpcManager.getMembers();
        EasyMock.expect((Object)rpcManager.getMembers()).andReturn((Object)memberList).anyTimes();
        ComponentRegistry cr = TestingUtil.extractComponentRegistry(tl.cache1);
        cr.registerComponent((Object)rpcManager, RPCManager.class);
        cr.rewire();
        if (!this.isUsingInvalidation()) {
            EasyMock.expect((Object)rpcManager.callRemoteMethods(this.anyAddresses(), (ReplicableCommand)EasyMock.anyObject(), EasyMock.eq((boolean)false), EasyMock.anyLong(), EasyMock.anyBoolean())).andReturn(null);
        }
        EasyMock.replay((Object[])new Object[]{rpcManager});
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        EasyMock.verify((Object[])new Object[]{rpcManager});
        TestingUtil.extractComponentRegistry(tl.cache1).registerComponent((Object)originalRpcManager, RPCManager.class);
        tl.cache1.removeNode(this.fqn);
    }

    public void testTxSuspension() throws Exception {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        tl.cache1.put(this.parentFqn, (Object)"k", (Object)"v");
        tl.tm1.begin();
        tl.cache1.get(this.parentFqn, (Object)"k");
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        Transaction t = tl.tm1.suspend();
        this.asyncWait();
        this.assertLocked(this.parentFqn, tl.cache1, false);
        AssertJUnit.assertEquals((String)"PFER should have completed", (String)"v", (String)((String)tl.cache1.get(this.fqn, (Object)"k")));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"PFER should not have effected cache2", (Object)tl.cache2.get(this.fqn, (Object)"k"));
        } else {
            AssertJUnit.assertEquals((String)"PFER should have completed", (String)"v", (String)((String)tl.cache2.get(this.fqn, (Object)"k")));
        }
        tl.tm1.resume(t);
        tl.tm1.commit();
        AssertJUnit.assertEquals((String)"parent fqn tx should have completed", (String)"v", (String)((String)tl.cache1.get(this.parentFqn, (Object)"k")));
        if (this.isUsingInvalidation()) {
            AssertJUnit.assertNull((String)"parent fqn tx should have invalidated cache2", (Object)tl.cache2.get(this.parentFqn, (Object)"k"));
        } else {
            AssertJUnit.assertEquals((String)"parent fqn tx should have completed", (String)"v", (String)((String)tl.cache2.get(this.parentFqn, (Object)"k")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionSuppression() throws Exception {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        RPCManager barfingRpcManager = (RPCManager)EasyMock.createNiceMock(RPCManager.class);
        RPCManager originalRpcManager = tl.cache1.getConfiguration().getRuntimeConfig().getRPCManager();
        try {
            List memberList = originalRpcManager.getMembers();
            EasyMock.expect((Object)barfingRpcManager.getMembers()).andReturn((Object)memberList).anyTimes();
            EasyMock.expect((Object)barfingRpcManager.getLocalAddress()).andReturn((Object)originalRpcManager.getLocalAddress()).anyTimes();
            EasyMock.expect((Object)barfingRpcManager.callRemoteMethods(this.anyAddresses(), (ReplicableCommand)EasyMock.anyObject(), EasyMock.anyBoolean(), EasyMock.anyLong(), EasyMock.anyBoolean())).andThrow((Throwable)new RuntimeException("Barf!")).anyTimes();
            EasyMock.replay((Object[])new Object[]{barfingRpcManager});
            TestingUtil.extractComponentRegistry(tl.cache1).registerComponent((Object)barfingRpcManager, RPCManager.class);
            tl.cache1.getConfiguration().getRuntimeConfig().setRPCManager(barfingRpcManager);
            TestingUtil.extractComponentRegistry(tl.cache1).rewire();
            try {
                tl.cache1.put(this.fqn, (Object)"k", (Object)"v");
                if (!this.isOptimistic()) {
                    AssertJUnit.fail((String)"Should have barfed");
                }
            }
            catch (RuntimeException re) {
                // empty catch block
            }
            if (this.isOptimistic() && !this.isUsingInvalidation()) {
                AssertJUnit.assertNull((Object)tl.cache1.get(this.fqn, (Object)"k"));
            } else {
                try {
                    tl.cache1.removeNode(this.fqn);
                    if (!this.isUsingInvalidation()) {
                        AssertJUnit.fail((String)"Should have barfed");
                    }
                }
                catch (RuntimeException re) {
                    // empty catch block
                }
            }
            AssertJUnit.assertNull((String)"Should have cleaned up", (Object)tl.cache1.get(this.fqn, (Object)"k"));
            tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        }
        finally {
            TestingUtil.extractComponentRegistry(tl.cache1).registerComponent((Object)originalRpcManager, RPCManager.class);
        }
    }

    public void testBasicPropagation() throws Exception {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        assert (!tl.cache1.exists(this.fqn));
        assert (!tl.cache2.exists(this.fqn));
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        this.asyncWait();
        AssertJUnit.assertEquals((String)"PFER updated cache1", (String)"v", (String)((String)tl.cache1.get(this.fqn, (Object)"k")));
        String expected = this.isUsingInvalidation() ? null : "v";
        AssertJUnit.assertEquals((String)"PFER propagated to cache2 as expected", (Object)expected, (Object)tl.cache2.get(this.fqn, (Object)"k"));
        tl.cache2.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"PFER updated cache2", (String)"v", (String)((String)tl.cache2.get(this.fqn, (Object)"k")));
        AssertJUnit.assertEquals((String)"Cache1 should be unaffected", (String)"v", (String)((String)tl.cache1.get(this.fqn, (Object)"k")));
    }

    public void testSimpleCacheModeLocal() throws Exception {
        this.cacheModeLocalTest(false);
    }

    public void testCacheModeLocalInTx() throws Exception {
        this.cacheModeLocalTest(true);
    }

    public void testMemLeakOnSuspendedTransactions() throws Exception {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        Fqn fqn2 = Fqn.fromString((String)"/fqn/two");
        tl.tm1.begin();
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        tl.tm1.commit();
        TestingUtil.sleepThread(500L);
        assert (tl.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (tl.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (tl.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (tl.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
        tl.tm1.begin();
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        tl.cache1.put(fqn2, (Object)"k", (Object)"v");
        tl.tm1.commit();
        this.asyncWait();
        assert (tl.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (tl.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (tl.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (tl.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
        tl.tm1.begin();
        tl.cache1.put(fqn2, (Object)"k", (Object)"v");
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        tl.tm1.commit();
        this.asyncWait();
        assert (tl.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (tl.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (tl.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (tl.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
        tl.tm1.begin();
        tl.cache1.put(fqn2, (Object)"k", (Object)"v");
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        tl.cache1.put(fqn2, (Object)"k", (Object)"v");
        tl.tm1.commit();
        this.asyncWait();
        assert (tl.cache1.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 1 should have no stale global TXs";
        assert (tl.cache1.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 1 should have no stale local TXs";
        assert (tl.cache2.getTransactionTable().getNumGlobalTransactions() == 0) : "Cache 2 should have no stale global TXs";
        assert (tl.cache2.getTransactionTable().getNumLocalTransactions() == 0) : "Cache 2 should have no stale local TXs";
    }

    private void cacheModeLocalTest(boolean transactional) throws Exception {
        PutForExternalReadTestBaseTL tl = this.threadLocal.get();
        RPCManager rpcManager = (RPCManager)EasyMock.createMock(RPCManager.class);
        RPCManager originalRpcManager = tl.cache1.getConfiguration().getRuntimeConfig().getRPCManager();
        tl.cache1.getConfiguration().getRuntimeConfig().setRPCManager(rpcManager);
        EasyMock.replay((Object[])new Object[]{rpcManager});
        if (transactional) {
            tl.tm1.begin();
        }
        tl.cache1.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
        tl.cache1.putForExternalRead(this.fqn, (Object)"k", (Object)"v");
        if (transactional) {
            tl.tm1.commit();
        }
        EasyMock.verify((Object[])new Object[]{rpcManager});
        tl.cache1.getConfiguration().getRuntimeConfig().setRPCManager(originalRpcManager);
        tl.cache1.removeNode(this.fqn);
    }

    protected abstract void assertLocked(Fqn var1, CacheSPI var2, boolean var3);

    protected TransactionWorkspace extractTransactionWorkspace(Cache c) {
        CacheSPI cs = (CacheSPI)c;
        try {
            GlobalTransaction gtx = cs.getTransactionTable().get(cs.getTransactionManager().getTransaction());
            OptimisticTransactionContext entry = (OptimisticTransactionContext)cs.getTransactionTable().get(gtx);
            return entry.getTransactionWorkSpace();
        }
        catch (SystemException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)"Unable to extract transaction workspace from cache");
            return null;
        }
    }

    protected boolean isUsingInvalidation() {
        return this.cacheMode.isInvalidation();
    }

    protected boolean isAsync() {
        return !this.cacheMode.isSynchronous();
    }

    protected boolean isOptimistic() {
        return this.nodeLockingScheme == Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    protected void asyncWait() {
        TestingUtil.sleepThread(500L);
    }

    protected class PutForExternalReadTestBaseTL {
        protected CacheSPI<String, String> cache1;
        protected CacheSPI<String, String> cache2;
        ReplicationListener replListener1;
        ReplicationListener replListener2;
        protected TransactionManager tm1;
        protected TransactionManager tm2;
        protected boolean useTx;

        protected PutForExternalReadTestBaseTL() {
        }
    }
}

