/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocator;
import org.jboss.cache.buddyreplication.NextMemberBuddyLocatorConfig;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.parsing.XmlConfigHelper;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.element.BuddyElementParser;
import org.jboss.cache.interceptors.LegacyDataGravitatorInterceptor;
import org.jboss.cache.interceptors.base.CommandInterceptor;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

@Test(groups={"functional", "jgroups"}, sequential=true)
public class BuddyReplicationConfigTest {
    private CacheSPI<Object, Object> cache;

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
    }

    public void testNullConfig() throws Exception {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setBuddyReplicationConfig(null);
        AssertJUnit.assertNull((Object)this.cache.getBuddyManager());
    }

    public void testDisabledConfig() throws Exception {
        String xmlConfig = "<buddy enabled=\"false\"/>";
        BuddyReplicationConfig config = this.getBuddyReplicationConfig(xmlConfig);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setBuddyReplicationConfig(config);
        AssertJUnit.assertNull((Object)this.cache.getBuddyManager());
    }

    public void testBasicConfig() throws Exception {
        String xmlConfig = "<buddy enabled=\"true\"/>";
        BuddyReplicationConfig config = this.getBuddyReplicationConfig(xmlConfig);
        Configuration c = new Configuration();
        c.setCacheMode(Configuration.CacheMode.REPL_SYNC);
        c.setBuddyReplicationConfig(config);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(c, false);
        this.cache.create();
        this.cache.start();
        AssertJUnit.assertNotNull((Object)this.cache.getBuddyManager());
        BuddyManager mgr = this.cache.getBuddyManager();
        AssertJUnit.assertTrue((boolean)mgr.isEnabled());
        AssertJUnit.assertNull((Object)mgr.getBuddyPoolName());
        AssertJUnit.assertEquals(NextMemberBuddyLocator.class, mgr.buddyLocator.getClass());
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)mgr.buddyLocator.getConfig();
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
    }

    private BuddyReplicationConfig getBuddyReplicationConfig(String xmlConfig) throws Exception {
        Element element = XmlConfigHelper.stringToElementInCoreNS((String)xmlConfig);
        BuddyElementParser elementParser = new BuddyElementParser();
        BuddyReplicationConfig config = elementParser.parseBuddyElement(element);
        return config;
    }

    public void testXmlConfig() throws Exception {
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(new XmlConfigurationParser().parseFile("configs/buddy-replication-cache.xml"), false);
        this.cache.create();
        this.cache.start();
        BuddyManager bm = this.cache.getBuddyManager();
        AssertJUnit.assertNotNull((Object)bm);
        AssertJUnit.assertTrue((boolean)bm.isEnabled());
        AssertJUnit.assertTrue((boolean)(bm.buddyLocator instanceof NextMemberBuddyLocator));
        NextMemberBuddyLocator bl = (NextMemberBuddyLocator)bm.buddyLocator;
        NextMemberBuddyLocatorConfig blc = (NextMemberBuddyLocatorConfig)bl.getConfig();
        AssertJUnit.assertTrue((boolean)blc.isIgnoreColocatedBuddies());
        AssertJUnit.assertEquals((int)1, (int)blc.getNumBuddies());
        AssertJUnit.assertEquals((String)"myBuddyPoolReplicationGroup", (String)bm.getConfig().getBuddyPoolName());
        AssertJUnit.assertEquals((int)2000, (int)bm.getConfig().getBuddyCommunicationTimeout());
        boolean hasDG = false;
        for (CommandInterceptor interceptor : this.cache.getInterceptorChain()) {
            hasDG = hasDG || interceptor instanceof LegacyDataGravitatorInterceptor;
        }
        System.out.println(this.cache.getInterceptorChain());
        AssertJUnit.assertTrue((String)"Should have a data gravitator!!", (boolean)hasDG);
    }

    public void testLocalModeConfig() throws Exception {
        String xmlConfig = "<buddy enabled=\"true\"/>";
        BuddyReplicationConfig config = this.getBuddyReplicationConfig(xmlConfig);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(false);
        this.cache.getConfiguration().setBuddyReplicationConfig(config);
        this.cache.create();
        this.cache.start();
        assert (this.cache.getBuddyManager() == null);
        this.cache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
        this.cache.getNode(Fqn.fromString((String)"/nonexistent"));
    }
}

