/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.List;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "jgroups"})
public class BuddyReplicationWithTransactionsTest
extends BuddyReplicationTestsBase {
    private Fqn fqn = Fqn.fromString((String)"test");
    private String key = "key";
    private String value = "value";
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    public void testTransactionsCommit() throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCaches(3, false, true, false);
        this.cachesTL.set(caches);
        caches.get(0).put(this.fqn, (Object)this.key, (Object)this.value);
        Fqn oldBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(caches.get(0).getLocalAddress()) + "/test"));
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(caches.get(2).getLocalAddress()) + "/test"));
        TestingUtil.dumpCacheContents(caches);
        TransactionManager txman = caches.get(2).getTransactionManager();
        AssertJUnit.assertTrue((boolean)caches.get(0).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(1).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!caches.get(2).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.begin();
        TestingUtil.dumpCacheContents(caches);
        caches.get(2).get(this.fqn, (Object)this.key);
        TestingUtil.dumpCacheContents(caches);
        AssertJUnit.assertTrue((boolean)caches.get(0).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(2).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(0).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(1).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!caches.get(2).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.commit();
        this.cleanupDelay();
        TestingUtil.dumpCacheContents(caches);
        AssertJUnit.assertTrue((!caches.get(0).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(2).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(0).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(0).exists(newBackupFqn));
        AssertJUnit.assertTrue((!caches.get(1).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(newBackupFqn) ? 1 : 0) != 0);
        TestingUtil.dumpCacheContents(caches);
        this.assertNoLocks(caches);
    }

    private void cleanupDelay() {
        TestingUtil.sleepThread(250L);
    }

    public void testTransactionsRollback() throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCaches(3, false, true, false);
        this.cachesTL.set(caches);
        caches.get(0).put(this.fqn, (Object)this.key, (Object)this.value);
        Fqn oldBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(caches.get(0).getLocalAddress()) + "/test"));
        Fqn newBackupFqn = Fqn.fromString((String)("/_BUDDY_BACKUP_/" + this.fqnTransformer.getGroupNameFromAddress(caches.get(2).getLocalAddress()) + "/test"));
        TestingUtil.dumpCacheContents(caches);
        TransactionManager txman = caches.get(2).getTransactionManager();
        AssertJUnit.assertTrue((boolean)caches.get(0).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(1).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!caches.get(2).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.begin();
        TestingUtil.dumpCacheContents(caches);
        caches.get(2).get(this.fqn, (Object)this.key);
        TestingUtil.dumpCacheContents(caches);
        AssertJUnit.assertTrue((boolean)caches.get(0).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(2).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(0).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(1).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!caches.get(2).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(newBackupFqn) ? 1 : 0) != 0);
        txman.rollback();
        TestingUtil.dumpCacheContents(caches);
        AssertJUnit.assertTrue((boolean)caches.get(0).exists(this.fqn));
        AssertJUnit.assertTrue((!caches.get(1).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(this.fqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((boolean)caches.get(1).exists(oldBackupFqn));
        AssertJUnit.assertTrue((!caches.get(2).exists(oldBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(0).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(1).exists(newBackupFqn) ? 1 : 0) != 0);
        AssertJUnit.assertTrue((!caches.get(2).exists(newBackupFqn) ? 1 : 0) != 0);
        this.assertNoLocks(caches);
    }
}

