/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class EmptyRegionTest
extends BuddyReplicationTestsBase {
    CacheSPI c1;
    CacheSPI c2;
    Fqn regionFqn = Fqn.fromString((String)"/a/b/c");
    Fqn region2Fqn = Fqn.fromString((String)"/d/e/f");
    Region region;
    Region region2;
    CountDownLatch buddyJoinLatch = new CountDownLatch(1);

    @BeforeMethod
    public void setUp() throws Exception {
        this.c1 = this.createCache(1, null, false, false, false);
        this.c1.getConfiguration().setUseRegionBasedMarshalling(true);
        this.c1.getConfiguration().setFetchInMemoryState(true);
        this.c2 = (CacheSPI)new UnitTestCacheFactory().createCache(this.c1.getConfiguration().clone(), false);
        this.c1.start();
        this.region = this.c1.getRegion(this.regionFqn, true);
        this.region2 = this.c1.getRegion(this.region2Fqn, true);
        this.region.registerContextClassLoader(this.getClass().getClassLoader());
        this.region2.registerContextClassLoader(this.getClass().getClassLoader());
        this.c1.put(this.region2Fqn, (Object)"key", (Object)"value");
        this.c2.create();
        this.c2.addCacheListener((Object)new BuddyJoinListener());
    }

    @AfterMethod
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.c1, this.c2});
        this.c1 = null;
        this.c2 = null;
    }

    public void testEmptyRegion() throws InterruptedException {
        assert (this.c1.getNode(this.regionFqn) == null) : "Node should not exist";
        assert (this.c1.getRegion(this.regionFqn, false) != null) : "Region should exist";
        assert (this.c1.getRegion(this.regionFqn, false).isActive()) : "Region should be active";
        this.c2.start();
        this.buddyJoinLatch.await(60L, TimeUnit.SECONDS);
        System.out.println("Cache1 " + CachePrinter.printCacheDetails((Cache)this.c1));
        System.out.println("Cache2 " + CachePrinter.printCacheDetails((Cache)this.c2));
        assert (this.c2.peek(this.fqnTransformer.getBackupFqn(this.c1.getLocalAddress(), this.region2Fqn), false) != null) : "Region2 state should have transferred!";
    }

    @CacheListener
    public class BuddyJoinListener {
        @BuddyGroupChanged
        public void buddyJoined(Event e) {
            EmptyRegionTest.this.buddyJoinLatch.countDown();
        }
    }
}

