/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.List;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.BuddyReplicationTestsBase;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class GravitationCleanupTest
extends BuddyReplicationTestsBase {
    Fqn fqn = Fqn.fromString((String)"/a/b/c");
    Object key = "key";
    Object value = "value";
    BuddyFqnTransformer fqnTransformer = new BuddyFqnTransformer();

    public void testStaleRegionOnDataOwnerPessimistic() throws Exception {
        this.testDataOwner(false);
    }

    public void testStaleRegionOnDataOwnerOptimistic() throws Exception {
        this.testDataOwner(true);
    }

    public void testStaleRegionOnBuddyPessimistic() throws Exception {
        this.testBuddy(false);
    }

    public void testStaleRegionOnBuddyOptimistic() throws Exception {
        this.testBuddy(true);
    }

    private void testDataOwner(boolean optimistic) throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCaches(1, 2, false, true, optimistic);
        this.cachesTL.set(caches);
        CacheSPI<Object, Object> dataOwner = caches.get(0);
        CacheSPI<Object, Object> buddy = caches.get(1);
        dataOwner.put(this.fqn, this.key, this.value);
        System.out.println("dataOwner: " + CachePrinter.printCacheDetails(dataOwner));
        System.out.println("buddy: " + CachePrinter.printCacheDetails(buddy));
        assert (dataOwner.peek(this.fqn, false) != null) : "Should have data";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (buddy.peek(this.fqn, false) == null) : "Should not have data";
        assert (buddy.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (buddy.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (buddy.peek(this.fqnTransformer.getBackupFqn(dataOwner.getLocalAddress(), this.fqn), false) != null) : "Should have backup data";
        assert (buddy.get(this.fqn, this.key).equals(this.value)) : "Data should have gravitated!";
        this.cleanupDelay();
        System.out.println("dataOwner: " + CachePrinter.printCacheDetails(dataOwner));
        System.out.println("buddy: " + CachePrinter.printCacheDetails(buddy));
        assert (buddy.peek(this.fqn, false) != null) : "Should have data";
        assert (buddy.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (buddy.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (dataOwner.peek(this.fqn, false) == null) : "Should not have data";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (dataOwner.peek(this.fqnTransformer.getBackupFqn(buddy.getLocalAddress(), this.fqn), false) != null) : "Should have backup data";
    }

    private void testBuddy(boolean optimistic) throws Exception {
        List<CacheSPI<Object, Object>> caches = this.createCaches(1, 3, false, true, optimistic);
        this.cachesTL.set(caches);
        CacheSPI<Object, Object> dataOwner = caches.get(0);
        CacheSPI<Object, Object> buddy = caches.get(1);
        CacheSPI<Object, Object> thirdInstance = caches.get(2);
        this.assertIsBuddy((Cache)dataOwner, (Cache)buddy, true);
        this.assertIsBuddy((Cache)buddy, (Cache)thirdInstance, true);
        this.assertIsBuddy((Cache)thirdInstance, (Cache)dataOwner, true);
        dataOwner.put(this.fqn, this.key, this.value);
        System.out.println("dataOwner: " + CachePrinter.printCacheLockingInfo(dataOwner));
        System.out.println("buddy: " + CachePrinter.printCacheLockingInfo(buddy));
        System.out.println("thirdInstance: " + CachePrinter.printCacheLockingInfo(thirdInstance));
        assert (dataOwner.peek(this.fqn, false) != null) : "Should have data";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(thirdInstance.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) == null) : "Should NOT have backup node for 2nd instance!";
        assert (buddy.peek(this.fqn, false) == null) : "Should not have data";
        assert (buddy.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (buddy.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (buddy.peek(this.fqnTransformer.getBackupFqn(dataOwner.getLocalAddress(), this.fqn), false) != null) : "Should have backup data";
        assert (thirdInstance.get(this.fqn, this.key).equals(this.value)) : "Data should have gravitated!";
        this.cleanupDelay();
        System.out.println("dataOwner: " + CachePrinter.printCacheLockingInfo(dataOwner));
        System.out.println("buddy: " + CachePrinter.printCacheLockingInfo(buddy));
        System.out.println("thirdInstance: " + CachePrinter.printCacheLockingInfo(thirdInstance));
        assert (thirdInstance.peek(this.fqn, false) != null) : "Should have data";
        assert (thirdInstance.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(buddy.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (thirdInstance.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(thirdInstance.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (dataOwner.peek(this.fqn, false) == null) : "Should not have data";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(dataOwner.getLocalAddress())}), false) == null) : "Should NOT have backup node for self!";
        assert (dataOwner.peek(Fqn.fromRelativeElements((Fqn)BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (Object[])new String[]{this.fqnTransformer.getGroupNameFromAddress(thirdInstance.getLocalAddress())}), false) != null) : "Should have backup node for buddy";
        assert (dataOwner.peek(this.fqnTransformer.getBackupFqn(thirdInstance.getLocalAddress(), this.fqn), false) != null) : "Should have backup data";
        assert (buddy.peek(this.fqn, false) == null) : "Should not have data";
        assert (buddy.peek(this.fqn.getParent(), false) == null) : "Should not have any part of the data";
        assert (buddy.peek(this.fqnTransformer.getBackupFqn(dataOwner.getLocalAddress(), this.fqn), false) == null) : "Should NOT have backup data";
    }

    private void cleanupDelay() {
        TestingUtil.sleepThread(250L);
    }
}

