/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands;

import java.util.HashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class StructuralNodesOnRollbackTest {
    private CacheSPI<Object, Object> cache;
    private TransactionManager txMgr;

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Configuration cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, false);
        this.cache = (CacheSPI)new UnitTestCacheFactory().createCache(cacheConfig);
        this.txMgr = this.cache.getTransactionManager();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        TestingUtil.killCaches(new Cache[]{this.cache});
        this.cache = null;
        this.txMgr = null;
    }

    public void testNoTx() throws Exception {
        this.txMgr.begin();
        this.cache.put("/a/b/c", (Object)"k", (Object)"v");
        NodeSPI root = this.cache.getRoot();
        assert (root.getChild((Object)"a") != null);
        assert (root.getChild(Fqn.fromString((String)"/a/b/c")) != null);
        assert (this.cache.exists("/a/b"));
        this.txMgr.rollback();
    }

    public void testPutDataMap() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("k", "v");
        assert (!this.cache.exists("/a/b"));
        this.txMgr.begin();
        this.cache.put("/a/b/c", map);
        assert (this.cache.exists("/a/b"));
        this.txMgr.rollback();
        assert (!this.cache.exists("/a/b"));
    }

    public void testPutKeyValueCommand() throws Exception {
        assert (!this.cache.exists("/a/b"));
        this.txMgr.begin();
        this.cache.put("/a/b/c", (Object)"key", (Object)"value");
        assert (this.cache.exists("/a/b"));
        this.txMgr.rollback();
        assert (!this.cache.exists("/a/b"));
    }
}

