/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.jboss.cache.commands.legacy.write.CreateNodeCommand;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.mock.MockNodesFixture;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class CreateNodeCommandTest
extends AbstractDataCommandTest {
    CreateNodeCommand command;
    private Object[] result;
    private ArrayList createdNodes;

    protected void moreSetup() {
        this.command = new CreateNodeCommand(this.testFqn);
        this.command.initialize(this.container);
        this.createdNodes = new ArrayList();
        this.result = new Object[2];
        this.result[0] = this.createdNodes;
    }

    public void testPerformNoNodesCreated() {
        EasyMock.expect((Object)this.container.createNodes(this.testFqn)).andReturn((Object)this.result);
        EasyMock.replay((Object[])new Object[]{this.container});
        assert (null == this.command.perform(this.ctx));
        assert (this.command.getNewlyCreated().isEmpty());
    }

    public void testPerformWithCreatedNodes() {
        MockNodesFixture nodes = new MockNodesFixture();
        this.createdNodes.add(nodes.aNode);
        this.createdNodes.add(nodes.abNode);
        this.createdNodes.add(nodes.abcNode);
        this.result[1] = nodes.abcNode;
        EasyMock.expect((Object)this.container.createNodes(this.testFqn)).andReturn((Object)this.result);
        EasyMock.replay((Object[])new Object[]{this.container});
        assert (nodes.abcNode == this.command.perform(this.ctx));
        assert (this.command.getNewlyCreated().size() == 3);
        assert (this.command.getNewlyCreated().contains(nodes.a));
        assert (this.command.getNewlyCreated().contains(nodes.ab));
        assert (this.command.getNewlyCreated().contains(nodes.abc));
    }

    public void testRollback() {
        MockNodesFixture nodes = new MockNodesFixture();
        this.createdNodes.add(nodes.aNode);
        this.createdNodes.add(nodes.abNode);
        this.createdNodes.add(nodes.abcNode);
        EasyMock.expect((Object)this.container.createNodes(this.testFqn)).andReturn((Object)this.result);
        EasyMock.expect((Object)this.container.removeFromDataStructure(nodes.a, true)).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)this.container.removeFromDataStructure(nodes.ab, true)).andReturn((Object)Boolean.TRUE);
        EasyMock.expect((Object)this.container.removeFromDataStructure(nodes.abc, true)).andReturn((Object)Boolean.TRUE);
        EasyMock.replay((Object[])new Object[]{this.container});
        this.command.perform(this.ctx);
        this.command.rollback();
        EasyMock.verify((Object[])new Object[]{this.container});
    }
}

