/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.legacy.write;

import org.easymock.EasyMock;
import org.jboss.cache.commands.legacy.write.PessRemoveNodeCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.commands.write.AbstractVersionedDataCommandTest;
import org.jboss.cache.transaction.GlobalTransaction;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class RemoveNodeCommandTest
extends AbstractVersionedDataCommandTest {
    PessRemoveNodeCommand command;

    public AbstractVersionedDataCommand moreSetUp() {
        this.command = new PessRemoveNodeCommand(this.globalTransaction, this.fqn);
        this.command.setDataVersion(this.dataVersion);
        return this.command;
    }

    public void testNonExistentNode() {
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn(null);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn(null);
        this.control.replay();
        assert (Boolean.FALSE == this.command.perform(this.ctx)) : "nonexistent node was not remove; false expected";
    }

    public void testRemovalNoNotificationsValidNode() {
        this.command.setSkipSendingNodeEvents(true);
        this.nodes.adfNode.put("akey", "avalue");
        this.nodes.adfNode.setVersion(this.dataVersion);
        this.ctx.setGlobalTransaction(new GlobalTransaction());
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        assert (Boolean.TRUE == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.isDeleted());
        assert (this.nodes.adfhNode.isDeleted());
        assert (this.command.originalData != null);
        this.control.verify();
        this.control.reset();
        this.nodes.adNode.removeChild("f");
        EasyMock.expect((Object)this.container.peek(this.nodes.ad)).andReturn((Object)this.nodes.adNode);
        this.control.replay();
        this.command.rollback();
        assert (this.nodes.adNode.hasChild("f"));
    }

    public void testRemovalNoNotificationsInvalidNode() {
        this.command.setSkipSendingNodeEvents(true);
        this.nodes.adfNode.setValid(false, false);
        this.nodes.adfNode.setVersion(this.dataVersion);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfNode);
        this.control.replay();
        assert (Boolean.FALSE == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.isDeleted());
        assert (this.nodes.adfhNode.isDeleted());
        this.control.verify();
    }

    public void testRemovalWithNotificationsInvalidNode() {
        this.nodes.adfNode.setValid(false, false);
        this.nodes.adfNode.setVersion(this.dataVersion);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfNode);
        EasyMock.expect((Object)this.container.peek(this.fqn)).andReturn((Object)this.nodes.adfNode);
        this.notifier.notifyNodeRemoved(this.fqn, true, this.nodes.adfNode.getDataDirect(), this.ctx);
        this.notifier.notifyNodeRemoved(this.fqn, false, null, this.ctx);
        this.control.replay();
        assert (Boolean.FALSE == this.command.perform(this.ctx));
        assert (this.nodes.adfgNode.isDeleted());
        assert (this.nodes.adfhNode.isDeleted());
        this.control.verify();
    }
}

