/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.Map;
import org.easymock.EasyMock;
import org.jboss.cache.commands.read.AbstractDataCommandTest;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.mock.NodeSpiMock;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true)
public class GetDataMapCommandTest
extends AbstractDataCommandTest {
    GetDataMapCommand command;

    protected void moreSetup() {
        this.command = new GetDataMapCommand(this.testFqn);
        this.command.initialize(this.container);
    }

    public void testForNonexistentNode() {
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.container});
        assert (null == this.command.perform(this.ctx));
    }

    public void testForExistingNode() {
        NodeSpiMock node = new NodeSpiMock(this.testFqn);
        node.putDirect("k1", "v1");
        node.putDirect("k2", "v2");
        EasyMock.expect((Object)this.container.peek(this.testFqn)).andReturn((Object)node);
        EasyMock.replay((Object[])new Object[]{this.container});
        Map result = (Map)this.command.perform(this.ctx);
        assert (2 == result.entrySet().size());
        assert (result.get("k1").equals("v1"));
        assert (result.get("k2").equals("v2"));
        try {
            result.put("k3", "v3");
            assert (false) : "map should be immutable";
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

