/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config.parsing;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.cache.Cache;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.parsing.XmlConfigurationParser;
import org.jboss.cache.config.parsing.XmlConfigurationSchemaTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.xml.sax.ErrorHandler;

@Test(groups={"functional"})
public class SampleConfigFilesCorrectnessTest {
    public static final String CONFIG_ROOT = "src/main/resources/config-samples";
    public static final String XSD_FILE = "src/main/resources/jbosscache-config-3.0.xsd";
    private InMemoryAppender appender;
    private Level oldLevel;

    @BeforeMethod
    public void setUpTest() {
        Logger log4jLogger = Logger.getRootLogger();
        this.oldLevel = log4jLogger.getLevel();
        log4jLogger.setLevel(Level.WARN);
        this.appender = new InMemoryAppender();
        log4jLogger.addAppender((Appender)this.appender);
        File f = new File(".");
        System.out.println("f = " + f.getAbsolutePath());
    }

    @AfterMethod
    public void tearDownTest() {
        Logger log4jLogger = Logger.getRootLogger();
        log4jLogger.setLevel(this.oldLevel);
        log4jLogger.removeAppender((Appender)this.appender);
        this.appender.close();
    }

    public void testSchemaValidity() {
        String[] configFiles;
        System.setProperty("jbosscache.config.schemaLocation", XSD_FILE);
        XmlConfigurationSchemaTest.ExceptionCountingErrorHandler errorHandler = new XmlConfigurationSchemaTest.ExceptionCountingErrorHandler();
        XmlConfigurationParser parser = new XmlConfigurationParser((ErrorHandler)errorHandler);
        for (String aConfFile : configFiles = this.getConfigFileNames()) {
            System.out.println("Processing file: " + aConfFile);
            parser.parseFile("src/main/resources/config-samples/" + aConfFile);
        }
        assert (errorHandler.noErrors());
    }

    public void testConfigWarnings() {
        UnitTestCacheFactory ucf = new UnitTestCacheFactory();
        for (String aConfFile : this.getConfigFileNames()) {
            System.out.println("Processing file: " + aConfFile);
            assert (!this.appender.isFoundUnknownWarning());
            Cache cache = ucf.createCache("src/main/resources/config-samples/" + aConfFile, false);
            assert (!this.appender.isFoundUnknownWarning());
        }
    }

    private String[] getConfigFileNames() {
        File file = new File(CONFIG_ROOT);
        return file.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.indexOf("xml") > 0;
            }
        });
    }

    private static class InMemoryAppender
    extends AppenderSkeleton {
        String[] TOLERABLE_WARNINGS = new String[]{"Falling back to DummyTransactionManager"};
        boolean foundUnknownWarning = false;

        private InMemoryAppender() {
        }

        protected void append(LoggingEvent event) {
            if (event.getLevel().equals((Object)Level.WARN)) {
                boolean skipPrinting = false;
                this.foundUnknownWarning = true;
                for (String knownWarn : this.TOLERABLE_WARNINGS) {
                    if (event.getMessage().toString().indexOf(knownWarn) < 0) continue;
                    skipPrinting = true;
                    this.foundUnknownWarning = false;
                }
                if (!skipPrinting) {
                    System.out.println("Unaccepted warn message :" + event.getMessage());
                }
            }
        }

        public boolean requiresLayout() {
            return false;
        }

        public void close() {
        }

        public boolean isFoundUnknownWarning() {
            return this.foundUnknownWarning;
        }
    }
}

